/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OutputComparator {
    Pattern javadocPattern = Pattern.compile("^\\s*[/]?\\*");
    static final Pattern STATUS_PATTERN = Pattern.compile("^\\s*\\/*\\s*[\\d:,]{12} \\|");
    static final Pattern OBJECT_ID_PATTERN = Pattern.compile("@[\\dA-Fa-f]{4,10} ");

    public boolean checkForEquality(List<String> witnessList, List<String> subjectList) {
        int lenSubject;
        List<String> cleanWitnessList = this.clean(witnessList);
        List<String> cleanSubjectList = this.clean(subjectList);
        int lenWitness = cleanWitnessList.size();
        if (lenWitness != (lenSubject = cleanSubjectList.size())) {
            System.out.println("Lists of different sizes " + lenWitness + "!=" + lenSubject);
            return false;
        }
        for (int i = 0; i < lenWitness; ++i) {
            String s;
            String w = cleanWitnessList.get(i).trim();
            if (w.equals(s = cleanSubjectList.get(i).trim())) continue;
            System.out.println("lists differ on line " + i);
            System.out.println("w= " + w);
            System.out.println("s= " + s);
            return false;
        }
        return true;
    }

    private List<String> clean(List<String> inputList) {
        ArrayList<String> cleanList = new ArrayList<String>();
        for (String s : inputList) {
            String replacement = this.processLine(s);
            if (replacement == null) continue;
            cleanList.add(replacement);
        }
        return cleanList;
    }

    private String processLine(String s) {
        if (s.isBlank()) {
            return null;
        }
        if (this.javadocPattern.matcher(s).find()) {
            return null;
        }
        Matcher statusMatcher = STATUS_PATTERN.matcher(s);
        if (statusMatcher.find()) {
            String cleaned = statusMatcher.replaceFirst("");
            String cleaned2 = this.cleanMemory(cleaned);
            return cleaned2;
        }
        return s;
    }

    private String cleanMemory(String input) {
        Matcher objectIdMatcher = OBJECT_ID_PATTERN.matcher(input);
        if (objectIdMatcher.find()) {
            String clean2 = objectIdMatcher.replaceFirst("@XXX ");
            return clean2;
        }
        return input;
    }
}

