/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base.compiler;

import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.tyler.base.compiler.CompilerVerificationResult;
import ch.qos.logback.tyler.base.compiler.JavaSourceFromString;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class CompilationVerifier {
    private static final String classpath;

    public CompilerVerificationResult verify(String name, String sourceCode) {
        CompilerVerificationResult compilerVerificationResult;
        block8: {
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();
            JavaSourceFromString source = new JavaSourceFromString(name, sourceCode);
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, Locale.getDefault(), Charset.defaultCharset());
            try {
                JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, List.of("-classpath", classpath), null, List.of(source));
                boolean compilationResult = task.call();
                compilerVerificationResult = new CompilerVerificationResult(compilationResult, diagnostics);
                if (fileManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileManager != null) {
                        try {
                            fileManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            fileManager.close();
        }
        return compilerVerificationResult;
    }

    static {
        char separatorChar;
        Object systemClasspath = System.getProperty("java.class.path");
        String modulePath = System.getProperty("jdk.module.path");
        char c = separatorChar = EnvUtil.isWindows() ? (char)';' : ':';
        if (modulePath != null && !modulePath.isBlank()) {
            systemClasspath = (String)systemClasspath + separatorChar + modulePath;
        }
        classpath = systemClasspath;
    }
}

