/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base.util;

import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.tyler.base.util.ClassUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ClassUtilTest {
    ClassUtilTest() {
    }

    @Test
    void smoke() {
        String packageName = "ch.qos";
        String className = "Toto";
        String fqcn = packageName + "." + className;
        Assertions.assertEquals((Object)packageName, (Object)ClassUtil.extractPackageName((String)fqcn));
        Assertions.assertEquals((Object)className, (Object)ClassUtil.extractSimpleClassName((String)fqcn));
    }

    @Test
    void isAuthorized() {
        Assertions.assertFalse((boolean)ClassUtil.isAuthorized((String)"tot"));
        Assertions.assertTrue((boolean)ClassUtil.isAuthorized((String)"chapters.filters"));
        Assertions.assertTrue((boolean)ClassUtil.isAuthorized((String)TimeBasedRollingPolicy.class.getName()));
    }

    @Test
    void classImplements() {
        boolean result = ClassUtil.classImplements(TimeBasedRollingPolicy.class, ContextAware.class);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void badFQCN() {
        String fqcn = "asd";
        Assertions.assertNull((Object)ClassUtil.extractPackageName((String)fqcn));
        Assertions.assertEquals((Object)fqcn, (Object)ClassUtil.extractSimpleClassName((String)fqcn));
        fqcn = "asd.toto.";
        Assertions.assertEquals((Object)"asd.toto", (Object)ClassUtil.extractPackageName((String)fqcn));
        Assertions.assertNull((Object)ClassUtil.extractSimpleClassName((String)fqcn));
    }
}

