/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.tyler.TylerConfiguratorBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.tyler.base.TylerConstants;
import ch.qos.logback.tyler.base.spi.StaticImportData;
import ch.qos.logback.tyler.base.util.ClassUtil;
import ch.qos.logback.tyler.base.util.VariableNameUtil;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;

public class TylerModelInterpretationContext
extends ModelInterpretationContext {
    public final TypeSpec.Builder tylerConfiguratorTSB;
    public final MethodSpec.Builder configureMethodSpecBuilder;
    public final Map<String, MethodSpec.Builder> mapOfMethodSpecBuilders = new LinkedHashMap<String, MethodSpec.Builder>();
    final FieldSpec contextFieldSpec = FieldSpec.builder(LoggerContext.class, (String)"context", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
    final ParameterSpec contextParameterSpec = ParameterSpec.builder(LoggerContext.class, (String)"loggerContext", (Modifier[])new Modifier[0]).build();
    final ParameterSpec levelParameterSpec = ParameterSpec.builder(Level.class, (String)"level", (Modifier[])new Modifier[0]).build();
    final List<FieldSpec> fieldSpecs = new ArrayList<FieldSpec>();
    final List<StaticImportData> staticImportsList = new ArrayList<StaticImportData>();

    public TylerModelInterpretationContext(Context context) {
        super(context);
        this.configureMethodSpecBuilder = this.initializeConfigureMethodSpecBuilder();
        this.tylerConfiguratorTSB = this.initializeTylerConfiguratorTSB();
    }

    public void addStaticImport(StaticImportData sid) {
        if (!this.staticImportsList.contains(sid)) {
            this.staticImportsList.add(sid);
        }
    }

    TypeSpec.Builder initializeTylerConfiguratorTSB() {
        TypeSpec.Builder tsb = TypeSpec.classBuilder((String)"TylerConfigurator").addJavadoc("\n<p>This file was generated by logback-tyler version %s</p>\n\n<p>Eventual errors and warnings are appended at the end.</p>\n\n<p>You may experiment with logback.xml to Java translation, i.e.\nTylerConfigurator generation, at the following URL:</p>\n\n<p>     https://logback.qos.ch/translator/services/xml2Java.html </p>\n\n<p>This generated TylerConfigurator class is intended to be copied and integrated\ninto the user's project as a custom configurator. It will configure logback\nwithout XML. You are free to rename TylerConfigurator as you wish.</p>\n\n<p>It requires logback-classic version %s or later at runtime.</p>\n\n<p>Custom configurators are looked up via Java's service-provide facility. If a\ncustom provider is found, it takes precedence over logback's own configurators,\ne.g. DefaultJoranConfigurator.</p>\n\n<p>To install your custom configurator to your project, add a\nprovider-configuration file to the following path:</p>\n\n<pre>  META-INF/services/ch.qos.logback.classic.spi.Configurator</pre>\n\n<p>This provider-configuration file should contain a line with the fully\nqualified class name of your tyler configurator.</p>\n\n<p>See also item 1 of 'Configuration at initialization' section at </p>\n\n<p>  https://logback.qos.ch/manual/configuration.html#auto_configuration</p>\n\n<p>With recent versions of logback and logback-tyler you can still\nconfigure logger levels dynamically using properties files. Note that\nconfiguration files in properties format can be watched for\nchanges. See the documentation on PropertiesConfigurator for more details.</p>\n\n<p>https://logback.qos.ch/manual/configuration.html#propertiesConfigurator</p>\n\n<p>Keep in mind that by integrating a .properties configuration file info\nyour tyler configurator, you can still change logger levels dynamically, without\nredeploying your application.</p>\n\n".formatted(TylerConstants.TYLER_VERSION, "1.5.20"), new Object[0]).addSuperinterface(Configurator.class).superclass(TylerConfiguratorBase.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        return tsb;
    }

    private MethodSpec.Builder initializeConfigureMethodSpecBuilder() {
        MethodSpec.Builder msb = MethodSpec.methodBuilder((String)"configure").addJavadoc("<p>This method performs configuration per {@link $T} interface.</p>\n\n<p>If <code>TylerConfigurator</code> is installed as a configurator service, this\nmethod will be called by logback-classic during initialization.</p>\n", new Object[]{Configurator.class}).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(this.contextParameterSpec).returns(Configurator.ExecutionStatus.class).addStatement("$N($N)", new Object[]{"setContext", this.contextParameterSpec});
        return msb;
    }

    public FieldSpec getContextFieldSpec() {
        return this.contextFieldSpec;
    }

    public FieldSpec createAppenderFieldSpec(ClassName desiredAppenderCN, String appenderName) {
        String appenderVariableName = VariableNameUtil.appenderNameToVariableName(appenderName);
        FieldSpec.Builder fieldSpecBuilder = FieldSpec.builder((TypeName)desiredAppenderCN, (String)appenderVariableName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PROTECTED});
        fieldSpecBuilder.addJavadoc("Appender variable referencing the appender named $S.", new Object[]{appenderName});
        return fieldSpecBuilder.build();
    }

    public FieldSpec createPropertyConditionFieldSpec(ClassName className, String variableName) {
        FieldSpec.Builder fieldSpecBuilder = FieldSpec.builder((TypeName)className, (String)variableName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PROTECTED});
        fieldSpecBuilder.addJavadoc("Variable used in conditional processing", new Object[0]);
        return fieldSpecBuilder.build();
    }

    public Collection<FieldSpec> getFieldSpecs() {
        return this.fieldSpecs;
    }

    public ClassName makeClassName(String fqcn) {
        String packageName = ClassUtil.extractPackageName(fqcn);
        String simpleName = ClassUtil.extractSimpleClassName(fqcn);
        return ClassName.get((String)packageName, (String)simpleName, (String[])new String[0]);
    }
}

