/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base.handler;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.AppenderModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.util.StringUtil;
import ch.qos.logback.tyler.base.TylerModelInterpretationContext;
import ch.qos.logback.tyler.base.handler.ImplicitModelHandlerData;
import ch.qos.logback.tyler.base.util.VariableNameUtil;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;

public class AppenderModelHandler
extends ModelHandlerBase {
    ImplicitModelHandlerData implicitModelHandlerData;
    private boolean skipped = false;
    boolean inError = false;

    public AppenderModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext mic) {
        return new AppenderModelHandler(context);
    }

    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        AppenderModel appenderModel = (AppenderModel)model;
        TylerModelInterpretationContext tmic = (TylerModelInterpretationContext)mic;
        String appenderName = tmic.subst(appenderModel.getName());
        String originalClassName = appenderModel.getClassName();
        String className = mic.getImport(originalClassName);
        MethodSpec.Builder methodSpec = this.addJavaStatementForAppenderInitialization(tmic, appenderName, className);
        try {
            Class<?> appenderClass = Class.forName(className);
            this.implicitModelHandlerData = new ImplicitModelHandlerData(appenderClass, "appender", methodSpec);
            mic.pushObject((Object)this.implicitModelHandlerData);
        }
        catch (ClassNotFoundException e) {
            this.addError("Could not find class", e);
            this.inError = true;
        }
    }

    MethodSpec.Builder addJavaStatementForAppenderInitialization(TylerModelInterpretationContext tmic, String appenderName, String fullyQualifiedAppenderClassName) {
        ClassName desiredAppenderCN = tmic.makeClassName(fullyQualifiedAppenderClassName);
        String fistLetterCapitalizedAppenderName = StringUtil.capitalizeFirstLetter((String)appenderName);
        String methodName = "setupAppender" + fistLetterCapitalizedAppenderName;
        String appenderVariableName = VariableNameUtil.appenderNameToVariableName(appenderName);
        FieldSpec fieldSpec = tmic.createAppenderFieldSpec(desiredAppenderCN, appenderName);
        tmic.getFieldSpecs().add(fieldSpec);
        tmic.configureMethodSpecBuilder.addStatement("this.$N = $N()", new Object[]{appenderVariableName, methodName});
        MethodSpec.Builder appenderSetupMethodSpec = MethodSpec.methodBuilder((String)methodName).returns((TypeName)desiredAppenderCN).addStatement("$1T $2N = new $1T()", new Object[]{desiredAppenderCN, "appender"}).addStatement("$N.setContext($N)", new Object[]{"appender", tmic.getContextFieldSpec()}).addStatement("$N.setName($S)", new Object[]{"appender", appenderName});
        return appenderSetupMethodSpec;
    }

    public void postHandle(ModelInterpretationContext mic, Model model) {
        if (this.inError) {
            return;
        }
        Object o = mic.peekObject();
        if (o != this.implicitModelHandlerData) {
            this.addWarn("The object at the of the stack is not the ImplicitModelHandlerData pushed earlier.");
        } else {
            TylerModelInterpretationContext tmic = (TylerModelInterpretationContext)mic;
            tmic.popObject();
            MethodSpec.Builder appenderMethodBuilder = this.implicitModelHandlerData.methodSpecBuilder;
            appenderMethodBuilder.addCode("\n", new Object[0]);
            appenderMethodBuilder.addStatement("$N.start()", new Object[]{"appender"});
            appenderMethodBuilder.addStatement("return $N", new Object[]{"appender"});
            MethodSpec appenderMethodSpec = appenderMethodBuilder.build();
            tmic.tylerConfiguratorTSB.addMethod(appenderMethodSpec);
        }
    }
}

