/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base.handler;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.AppenderRefModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.tyler.base.TylerModelInterpretationContext;
import ch.qos.logback.tyler.base.handler.ImplicitModelHandlerData;
import ch.qos.logback.tyler.base.util.VariableNameUtil;
import com.squareup.javapoet.MethodSpec;

public class AppenderRefModelHandler
extends ModelHandlerBase {
    boolean inError = false;

    public AppenderRefModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext ic) {
        return new AppenderRefModelHandler(context);
    }

    protected Class<? extends AppenderRefModel> getSupportedModelClass() {
        return AppenderRefModel.class;
    }

    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        TylerModelInterpretationContext tmic = (TylerModelInterpretationContext)mic;
        AppenderRefModel appenderRefModel = (AppenderRefModel)model;
        Object o = mic.peekObject();
        if (o instanceof String) {
            String loggerName = (String)o;
            String variableName = VariableNameUtil.loggerNameToVariableName(loggerName);
            this.addJavaStatement(tmic.configureMethodSpecBuilder, variableName, appenderRefModel.getRef());
        } else if (o instanceof ImplicitModelHandlerData) {
            ImplicitModelHandlerData implicitModelHandlerData = (ImplicitModelHandlerData)o;
            String variableName = implicitModelHandlerData.variableName;
            this.addJavaStatementForNestedAppender(implicitModelHandlerData.methodSpecBuilder, variableName, appenderRefModel.getRef());
        } else {
            this.inError = true;
            this.addError("Was expecting an object of type AppenderAttachableData");
            return;
        }
    }

    private void addJavaStatement(MethodSpec.Builder methodSpecBuilder, String variableName, String ref) {
        String appenderVariableName = VariableNameUtil.appenderNameToVariableName(ref);
        methodSpecBuilder.addStatement("$N.addAppender($N)", new Object[]{variableName, appenderVariableName});
    }

    private void addJavaStatementForNestedAppender(MethodSpec.Builder methodSpecBuilder, String variableName, String ref) {
        String nestedAppenderVariableName = VariableNameUtil.appenderNameToVariableName(ref);
        methodSpecBuilder.addComment("WARNING: It is assumed at this stage that the appender named $S was setup earlier.", new Object[]{ref});
        methodSpecBuilder.beginControlFlow("if($N == null)", new Object[]{nestedAppenderVariableName});
        methodSpecBuilder.addStatement("addError(\"Could not find appender named '$N'\")", new Object[]{ref});
        methodSpecBuilder.nextControlFlow("else", new Object[0]);
        methodSpecBuilder.addStatement("$N.addAppender($N)", new Object[]{variableName, nestedAppenderVariableName});
        methodSpecBuilder.endControlFlow();
    }
}

