/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base.handler;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.conditional.ByPropertiesConditionModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.util.StringUtil;
import ch.qos.logback.tyler.base.TylerModelInterpretationContext;
import ch.qos.logback.tyler.base.handler.ConditionStringRecord;
import ch.qos.logback.tyler.base.handler.ImplicitModelHandlerData;
import ch.qos.logback.tyler.base.util.VariableNameUtil;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;

public class ByPropertiesConditionModelHandler
extends ModelHandlerBase {
    static int COUNT;
    int instanceNum = COUNT++;
    boolean inError = false;
    ImplicitModelHandlerData implicitModelHandlerData;

    public ByPropertiesConditionModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext mic) {
        return new ByPropertiesConditionModelHandler(context);
    }

    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        ByPropertiesConditionModel byPropertiesConditionModel = (ByPropertiesConditionModel)model;
        TylerModelInterpretationContext tmic = (TylerModelInterpretationContext)mic;
        String originalClassName = byPropertiesConditionModel.getClassName();
        String classNameStr = mic.getImport(originalClassName);
        String conditionVariableName = VariableNameUtil.conditionModelToVariableName(classNameStr, this.instanceNum);
        MethodSpec.Builder methodSpecBuilder = this.addJavaStatementForAppenderInitialization(tmic, conditionVariableName, classNameStr);
        try {
            Class<?> propertyConditionClass = Class.forName(classNameStr);
            this.implicitModelHandlerData = new ImplicitModelHandlerData(propertyConditionClass, "propertyCondition", methodSpecBuilder);
            mic.pushObject((Object)this.implicitModelHandlerData);
        }
        catch (ClassNotFoundException e) {
            this.addError("Could not find class", e);
            this.inError = true;
        }
    }

    MethodSpec.Builder addJavaStatementForAppenderInitialization(TylerModelInterpretationContext tmic, String conditionVariableName, String fullyQualifiedAppenderClassName) {
        ClassName className = tmic.makeClassName(fullyQualifiedAppenderClassName);
        String fistLetterCapitalizedConditionName = StringUtil.capitalizeFirstLetter((String)conditionVariableName);
        String methodName = "setup" + fistLetterCapitalizedConditionName;
        FieldSpec fieldSpec = tmic.createPropertyConditionFieldSpec(className, conditionVariableName);
        tmic.getFieldSpecs().add(fieldSpec);
        tmic.configureMethodSpecBuilder.addStatement("this.$N = $N()", new Object[]{conditionVariableName, methodName});
        MethodSpec.Builder propertyConditionSetupMethodSpec = MethodSpec.methodBuilder((String)methodName).returns((TypeName)className).addStatement("$1T $2N = new $1T()", new Object[]{className, "propertyCondition"}).addStatement("$N.setContext($N)", new Object[]{"propertyCondition", tmic.getContextFieldSpec()}).addJavadoc("Setup method for $N\n", new Object[]{conditionVariableName});
        return propertyConditionSetupMethodSpec;
    }

    public void postHandle(ModelInterpretationContext mic, Model model) {
        if (this.inError) {
            return;
        }
        Object o = mic.peekObject();
        if (o != this.implicitModelHandlerData) {
            this.addWarn("The object at the of the stack is not the ImplicitModelHandlerData pushed earlier.");
        } else {
            TylerModelInterpretationContext tmic = (TylerModelInterpretationContext)mic;
            tmic.popObject();
            MethodSpec.Builder propertyConditionMethodBuilder = this.implicitModelHandlerData.methodSpecBuilder;
            String classNameStr = this.implicitModelHandlerData.parentObjectClass.getName();
            String conditionVariableName = VariableNameUtil.conditionModelToVariableName(classNameStr, this.instanceNum);
            propertyConditionMethodBuilder.addCode("\n", new Object[0]);
            propertyConditionMethodBuilder.addStatement("$N.start()", new Object[]{"propertyCondition"});
            propertyConditionMethodBuilder.addStatement("return $N", new Object[]{"propertyCondition"});
            MethodSpec propertyConditionMethodSpec = propertyConditionMethodBuilder.build();
            tmic.tylerConfiguratorTSB.addMethod(propertyConditionMethodSpec);
            mic.pushObject((Object)new ConditionStringRecord("this." + conditionVariableName + ".evaluate()"));
        }
    }
}

