/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base.handler;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.ActionUtil;
import ch.qos.logback.core.model.ComponentModel;
import ch.qos.logback.core.model.DefineModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.PropertyDefiner;
import ch.qos.logback.tyler.base.handler.ComponentModelHandler;
import ch.qos.logback.tyler.base.util.VariableNameUtil;
import com.squareup.javapoet.MethodSpec;

public class DefineModelHandler
extends ComponentModelHandler {
    static String PROPERTY_VALUE_VARIABLE_NAME = "propertyValue";
    static String SCOPE_VARIABLE_NAME = "scope";
    static int COUNT = 0;

    public DefineModelHandler(Context context) {
        super(context);
        this.instanceNum = COUNT++;
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext mic) {
        return new DefineModelHandler(context);
    }

    protected Class<DefineModel> getSupportedModelClass() {
        return DefineModel.class;
    }

    @Override
    String getTargetType() {
        return PropertyDefiner.class.getSimpleName();
    }

    @Override
    protected void addAdditionalJavaStatement(MethodSpec.Builder methodSpec, ComponentModel componentModel) {
        DefineModel defineModel = (DefineModel)componentModel;
        String componentClassName = componentModel.getClassName();
        String variableName = VariableNameUtil.fullyQualifiedClassNameToVariableName(componentClassName);
        String propertyName = defineModel.getName();
        String scopeStr = defineModel.getScopeStr();
        methodSpec.addStatement("$T $N  = $T.stringToScope($S)", new Object[]{ActionUtil.Scope.class, SCOPE_VARIABLE_NAME, ActionUtil.class, scopeStr});
        methodSpec.addStatement("String propertyValue = $N.getPropertyValue()", new Object[]{variableName});
        methodSpec.beginControlFlow("if(propertyValue != null)", new Object[0]);
        methodSpec.addStatement("addInfo(\"Setting property '$N' to '\"+$N+\"' in scope \"+$N)", new Object[]{propertyName, PROPERTY_VALUE_VARIABLE_NAME, SCOPE_VARIABLE_NAME});
        methodSpec.addStatement("$T.setProperty(this, $S, $N, $N)", new Object[]{ActionUtil.class, propertyName, PROPERTY_VALUE_VARIABLE_NAME, SCOPE_VARIABLE_NAME});
        methodSpec.endControlFlow();
    }
}

