/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base.handler;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.conditional.IfModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.tyler.base.TylerModelInterpretationContext;
import ch.qos.logback.tyler.base.handler.ConditionStringRecord;

public class IfModelHandler
extends ModelHandlerBase {
    public IfModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext ic) {
        return new IfModelHandler(context);
    }

    protected Class<IfModel> getSupportedModelClass() {
        return IfModel.class;
    }

    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        IfModel ifModel = (IfModel)model;
        TylerModelInterpretationContext tmic = (TylerModelInterpretationContext)mic;
        Object o = tmic.peekObject();
        String conditionStr = null;
        if (o instanceof ConditionStringRecord) {
            ConditionStringRecord conditionStringRecord = (ConditionStringRecord)o;
            conditionStr = conditionStringRecord.value();
            mic.popObject();
        }
        mic.pushModel((Model)ifModel);
        if (conditionStr == null) {
            conditionStr = ifModel.getCondition();
        }
        int lineNum = model.getLineNumber();
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)conditionStr)) {
            this.addJavaStatement(tmic, conditionStr);
        } else {
            this.addError("Empty condition for <if> element on line " + lineNum);
        }
    }

    protected void addJavaStatement(TylerModelInterpretationContext tmic, String conditionStr) {
        tmic.configureMethodSpecBuilder.beginControlFlow("if($N)", new Object[]{conditionStr});
    }

    public void postHandle(ModelInterpretationContext mic, Model model) {
        if (mic.isModelStackEmpty()) {
            this.addError("Unexpected unexpected empty model stack.");
            return;
        }
        Model o = mic.peekModel();
        if (!(o instanceof IfModel)) {
            this.addWarn("The object [" + String.valueOf(o) + "] on the top the of the stack is not of type [" + String.valueOf(IfModel.class));
        } else {
            TylerModelInterpretationContext tmic = (TylerModelInterpretationContext)mic;
            tmic.configureMethodSpecBuilder.endControlFlow();
            mic.popModel();
        }
    }
}

