/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.mistletoe.core;

import ch.qos.mistletoe.core.MistletoeCore;
import ch.qos.mistletoe.core.StopWatchRunListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestReport
implements Serializable {
    private static final long serialVersionUID = -1196521748389497981L;
    public static final String FAILURE_COLOR = "#BB4444";
    public static final String SUCCESS_COLOR = "#66bb66";
    final String displayName;
    final String className;
    final String methodName;
    final Throwable throwable;
    final double runtime;
    final ArrayList<TestReport> children = new ArrayList();

    public TestReport(Description description, MistletoeCore mCore) {
        this.displayName = description.getDisplayName();
        this.className = description.getClassName();
        this.methodName = description.getMethodName();
        this.runtime = this.findRuntime(description, mCore);
        Failure associatedFailure = this.findAssociatedFailure(description, mCore.result.getFailures());
        this.throwable = associatedFailure != null ? associatedFailure.getException() : null;
        for (Description childDescription : description.getChildren()) {
            TestReport childTR = new TestReport(childDescription, mCore);
            this.children.add(childTR);
        }
    }

    double findRuntime(Description d, MistletoeCore mCore) {
        StopWatchRunListener swRunListener = mCore.getStopWatchRunListener();
        return swRunListener.getRunTime(d);
    }

    private Failure findAssociatedFailure(Description d, List<Failure> failureList) {
        for (Failure f : failureList) {
            if (!f.getDescription().equals((Object)d)) continue;
            return f;
        }
        return null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public double getRuntime() {
        return this.runtime;
    }

    public int getTotalFailures() {
        int total = 0;
        if (this.throwable != null) {
            ++total;
        }
        for (TestReport child : this.children) {
            total += child.getTotalFailures();
        }
        return total;
    }

    public static TestReport getFistChildIfNecessary(TestReport description) {
        if (description.getDisplayName().equals("null")) {
            return description.getChildren().get(0);
        }
        return description;
    }

    public int getTestCount() {
        int total = 0;
        if (this.isTest()) {
            return 1;
        }
        for (TestReport child : this.children) {
            total += child.getTestCount();
        }
        return total;
    }

    public List<TestReport> getChildren() {
        return this.children;
    }

    public boolean isSuite() {
        return !this.isTest();
    }

    public boolean isTest() {
        return this.getChildren().isEmpty();
    }

    public boolean hasFailures() {
        if (this.throwable != null) {
            return true;
        }
        for (TestReport child : this.children) {
            if (!child.hasFailures()) continue;
            return true;
        }
        return false;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public double cumulativedRuntime() {
        double cumulative = this.runtime;
        for (TestReport child : this.children) {
            cumulative += child.cumulativedRuntime();
        }
        return cumulative;
    }

    public String toString() {
        String type = this.isTest() ? "isTest " : "isSuite";
        return "TestReport [displayName=" + this.displayName + ", methodName=" + this.methodName + ", " + type + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestReport other = (TestReport)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        return !(this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName));
    }
}

