/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.mistletoe.servlet;

import ch.qos.mistletoe.core.TestReport;
import ch.qos.mistletoe.core.helper.ExceptionHelper;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;

public class TestReportPrinter {
    static final String TEST_OK_GIF = "/images/testok.gif";
    static final String TEST_ERROR_GIF = "/images/testerr.gif";
    static final String TSUITE_OK_GIF = "/images/tsuiteok.gif";
    static final String TSUITE_ERROR_GIF = "/images/tsuiteerror.gif";
    HttpServletRequest request;
    PrintWriter out;

    TestReportPrinter(HttpServletRequest request, PrintWriter out) {
        this.request = request;
        this.out = out;
    }

    private void print(String msg) {
        this.out.print(msg);
        this.out.println();
    }

    private void printResultImage(String indent, TestReport testReport) {
        boolean hasFailures = testReport.hasFailures();
        boolean isSuite = testReport.isSuite();
        String testResultSrc = null;
        testResultSrc = isSuite ? (hasFailures ? this.adjusted(TSUITE_ERROR_GIF) : this.adjusted(TSUITE_OK_GIF)) : (hasFailures ? this.adjusted(TEST_ERROR_GIF) : this.adjusted(TEST_OK_GIF));
        this.print(indent + "<img width=\"16px\" height=\"16px\" border=\"0\" src=\"" + testResultSrc + "\"/>");
    }

    void printHeader() {
        this.print("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Strict//EN\">");
        this.print("<html>");
        this.print("<header>");
        this.print("  <style type=\"text/css\">");
        this.print("body {");
        this.print("  text-align: left;");
        this.print("  margin-left: 2ex;");
        this.print("  margin-right: 2ex;");
        this.print("  padding-left: 0px;");
        this.print("  padding-right: 0px;  ");
        this.print("}");
        this.print("td.icon {");
        this.print("  width: 16px;");
        this.print("}");
        this.print("");
        this.print(".description {");
        this.print("  padding-left: 1ex;");
        this.print("  text-align: left;  ");
        this.print("  width: 50em;");
        this.print("}");
        this.print("");
        this.print(".summaryBox {");
        this.print("  border: 1px inset #ccc;");
        this.print("  width: 40em;");
        this.print("}");
        this.print("");
        this.print(".exception {");
        this.print("  white-space: pre;");
        this.print("  margin-left: 1ex;  ");
        this.print("  background: #EEE; ");
        this.print("  font-family: courier, monospace;");
        this.print("  font-size: x-small;");
        this.print("  max-width: 180ex;");
        this.print("}");
        this.print("  </style>");
        this.print("");
        this.print("</header>");
    }

    void printFooter() {
        this.print("</body>");
        this.print("</html>");
    }

    void printAsTable(String indent, TestReport testReport) {
        this.print(indent + "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">");
        this.print(indent + "  <tr>");
        this.print(indent + "    <td>");
        this.printResultImage(indent + "  ", testReport);
        this.print(indent + "    </td>");
        this.print(indent + "    <td class=\"description\">" + testReport.getDisplayName() + "</td>");
        this.print(indent + "  </tr>");
        this.print(indent + "  <tr>");
        this.print(indent + "    <td></td>");
        this.print(indent + "    <td>");
        this.printPayload(indent + "  ", testReport);
        this.print(indent + "    </td>");
        this.print(indent + "  </tr>");
        this.print(indent + "</table>");
    }

    private void printPayload(String indent, TestReport testReport) {
        if (testReport.isTest() && testReport.getThrowable() == null) {
            this.handleSimple_OK_Description(indent);
        } else if (testReport.getThrowable() != null) {
            this.handle_NOT_OK_Description(indent, testReport);
        } else {
            this.handleDescriptionWithChildren(indent, testReport);
        }
    }

    private void handleSimple_OK_Description(String indent) {
        this.print("");
    }

    private void handle_NOT_OK_Description(String indent, TestReport testReport) {
        Throwable t = testReport.getThrowable();
        ExceptionHelper ex = new ExceptionHelper(t);
        this.out.print("<pre class=\"exception\">");
        this.out.println(ex.asString());
        this.out.println("</pre>");
    }

    private void handleDescriptionWithChildren(String indent, TestReport testReport) {
        for (TestReport child : testReport.getChildren()) {
            this.printAsTable(indent + "  ", child);
        }
    }

    void printSummary(TestReport testReport) {
        this.print("<p/>");
        this.print("<table>");
        this.print("  <tr>");
        this.print("    <td>Tests: " + testReport.getTestCount() + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Errors: " + testReport.getTotalFailures() + "</td>");
        this.print("    <td width=\"50%\"/>");
        this.print("   </tr>");
        this.print("   <tr>");
        this.print("     <td colspan=\"2\" class=\"summaryBox\" " + this.getSummaryBoxStyle(testReport) + ">&nbsp;</td>");
        this.print("   </tr>");
        this.print("   <tr><td style=\"line-height: 5px;\">&nbsp;</td></tr>");
        this.print("</table>");
    }

    private String getSummaryBoxStyle(TestReport testReport) {
        String backgroundColor = "#66bb66";
        if (testReport.hasFailures()) {
            backgroundColor = "#BB4444";
        }
        return "style=\"background: " + backgroundColor + ";\"";
    }

    private String adjusted(String resource) {
        return this.request.getContextPath() + resource;
    }
}

