/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.mistletoe.wicket;

import ch.qos.mistletoe.core.MistletoeCore;
import ch.qos.mistletoe.core.TestReport;
import ch.qos.mistletoe.wicket.SummaryMarkupContainer;
import ch.qos.mistletoe.wicket.TestReportPage;
import ch.qos.mistletoe.wicket.TestReportPanel;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RunTestForm
extends Form<String> {
    private static final long serialVersionUID = 1L;
    TestReportPage parent;

    RunTestForm(String id, TestReportPage parent) {
        super(id);
        this.parent = parent;
    }

    protected void onSubmit() {
        TextField tf = (TextField)this.get("testClassName");
        String targetClassStr = (String)tf.getDefaultModelObject();
        MistletoeCore mCore = null;
        try {
            mCore = new MistletoeCore(targetClassStr);
        }
        catch (ClassNotFoundException e) {
            this.error((Serializable)((Object)("Failed to find class " + targetClassStr)));
            return;
        }
        TestReport rootReport = mCore.run();
        rootReport = TestReport.getFistChildIfNecessary((TestReport)rootReport);
        TestReportPanel nodePanel = new TestReportPanel("node", rootReport);
        this.parent.remove("node");
        this.parent.add(new Component[]{nodePanel});
        this.parent.remove("summary");
        SummaryMarkupContainer summaryContainer = new SummaryMarkupContainer("summary", rootReport);
        this.parent.add(new Component[]{summaryContainer});
    }
}

