/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.mistletoe.wicket;

import ch.qos.mistletoe.core.TestReport;
import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;

public class SummaryMarkupContainer
extends WebMarkupContainer {
    private static final long serialVersionUID = -7378945281812473957L;

    SummaryMarkupContainer(String id, TestReport testReport) {
        super(id);
        if (testReport == null) {
            this.handleNullTestReport();
        } else {
            this.handleTestReport(testReport);
        }
    }

    void handleNullTestReport() {
        Label runsSummary = new Label("runsSummary", "");
        this.add(new Component[]{runsSummary});
        Label errorsSummary = new Label("errorsSummary", "");
        this.add(new Component[]{errorsSummary});
        Label summaryInColor = new Label("summaryInColor", "");
        this.add(new Component[]{summaryInColor});
        this.setVisible(false);
    }

    void handleTestReport(TestReport testReport) {
        Label runsSummary = new Label("runsSummary", "Total tests: " + testReport.getTestCount());
        this.add(new Component[]{runsSummary});
        Label errorsSummary = new Label("errorsSummary", "Errors/Failures: " + testReport.getTotalFailures());
        this.add(new Component[]{errorsSummary});
        Label summaryInColor = new Label("summaryInColor", "&nbsp;");
        summaryInColor.setEscapeModelStrings(false);
        String summaryColor = "#66bb66";
        if (testReport.hasFailures()) {
            summaryColor = "#BB4444";
        }
        summaryInColor.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)("background: " + summaryColor + ";")))});
        this.add(new Component[]{summaryInColor});
    }
}

