/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.mistletoe.wicket;

import ch.qos.mistletoe.core.MistletoeCore;
import ch.qos.mistletoe.core.TestReport;
import ch.qos.mistletoe.core.helper.ExceptionHelper;
import ch.qos.mistletoe.wicket.TreeExpansionLink;
import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class TestReportPanel
extends Panel {
    private static final long serialVersionUID = 2645889186544792364L;
    transient MistletoeCore core;
    transient TestReport testReport;

    public TestReportPanel(String id, TestReport testReport) {
        super(id);
        this.testReport = testReport;
        if (testReport.isTest()) {
            this.handleBlankPlaceHolderImage();
        } else {
            TreeExpansionLink link = new TreeExpansionLink("treeControl");
            this.add(new Component[]{link});
        }
        this.handleResultImage(testReport);
        this.add(new Component[]{new Label("name", testReport.getDisplayName())});
        if (testReport.isTest() && testReport.getThrowable() == null) {
            this.handleSimple_OK_Description();
        } else if (testReport.getThrowable() != null) {
            this.handle_NOT_OK_Description();
        } else {
            this.handleDescriptionWithChildren();
        }
        this.setOutputMarkupId(true);
    }

    void handleDescriptionWithChildren() {
        ListView<TestReport> listView = new ListView<TestReport>("payload", this.testReport.getChildren()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<TestReport> item) {
                TestReport childNode = (TestReport)item.getModelObject();
                item.add(new Component[]{new TestReportPanel("node", childNode)}).setOutputMarkupId(true);
            }
        };
        listView.setOutputMarkupId(true);
        this.add(new Component[]{listView});
    }

    void handleSimple_OK_Description() {
        WebMarkupContainer parent = new WebMarkupContainer("payload");
        this.add(new Component[]{parent});
        parent.add(new Component[]{new EmptyPanel("node").setVisible(false)});
    }

    void handle_NOT_OK_Description() {
        Throwable t = this.testReport.getThrowable();
        ExceptionHelper ex = new ExceptionHelper(t);
        WebMarkupContainer parent = new WebMarkupContainer("payload");
        this.add(new Component[]{parent});
        Label exception = new Label("node", ex.asString());
        exception.setEscapeModelStrings(false);
        exception.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"exception"))});
        parent.add(new Component[]{exception});
        if (ex.getLines() > 50) {
            AttributeModifier sam = new AttributeModifier("style", (Serializable)((Object)"height: 40em; overflow: scroll;"));
            exception.add(new Behavior[]{sam});
        }
    }

    void handleBlankPlaceHolderImage() {
        WebMarkupContainer parent = new WebMarkupContainer("treeControl");
        parent.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)"cursor: default;"))});
        Image image = new Image("treeControlSymbol", (ResourceReference)new PackageResourceReference(TestReportPanel.class, "images/blank.gif"));
        parent.add(new Component[]{image});
        this.add(new Component[]{parent});
    }

    void handleResultImage(TestReport description) {
        boolean hasFailures = description.hasFailures();
        boolean isSuite = description.isSuite();
        String testResultSrc = null;
        testResultSrc = isSuite ? (hasFailures ? "images/tsuiteerror.gif" : "images/tsuiteok.gif") : (hasFailures ? "images/testerr.gif" : "images/testok.gif");
        Image image = new Image("image", (ResourceReference)new PackageResourceReference(TestReportPanel.class, testResultSrc));
        this.add(new Component[]{image});
    }
}

