/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.mistletoe.wicket;

import ch.qos.mistletoe.wicket.TestReportPanel;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeExpansionLink
extends AjaxFallbackLink<Object> {
    private static final long serialVersionUID = 1L;
    boolean expanded = true;
    static String EXPAND_GIF = "images/expand.gif";
    static String COLLAPSE_GIF = "images/collapse.gif";

    public TreeExpansionLink(String id) {
        super(id);
        ResourceReference ref = this.getControlSymbolResourceReference(this.expanded);
        Image image = new Image("treeControlSymbol", ref);
        image.setOutputMarkupId(true);
        this.add(new Component[]{image});
    }

    public void onClick(AjaxRequestTarget target) {
        TestReportPanel nodePanel = (TestReportPanel)this.getParent();
        if (nodePanel == null || nodePanel.testReport == null) {
            this.warn((Serializable)((Object)"Failed to find node panel"));
            return;
        }
        if (nodePanel.testReport.isSuite()) {
            this.expanded = !this.expanded;
            TreeExpansionLink link = (TreeExpansionLink)nodePanel.get("treeControl");
            target.add(new Component[]{link.getParent()});
            Image image = (Image)link.get("treeControlSymbol");
            ResourceReference ref = this.getControlSymbolResourceReference(this.expanded);
            image.setImageResourceReference(ref);
            ListView payloadNode = (ListView)nodePanel.get("payload");
            payloadNode.setVisible(this.expanded);
            target.add(new Component[]{payloadNode.getParent()});
        }
    }

    ResourceReference getControlSymbolResourceReference(boolean expanded) {
        String raw = EXPAND_GIF;
        if (expanded) {
            raw = COLLAPSE_GIF;
        }
        return new PackageResourceReference(TestReportPanel.class, raw);
    }
}

