/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.base.jmx.registry.util;

import ch.raffael.meldioc.util.Classes;
import io.vavr.API;
import io.vavr.collection.Seq;
import javax.management.ObjectName;

public final class ObjectNames {
    private static final Seq<String> MBEAN_POSTFIXES = API.Seq((Object[])new String[]{"MBean", "MXBean"});
    private static final String SPECIAL_NAME_CHARS = "\"*?\\";

    private ObjectNames() {
    }

    public static String strippedName(String name) {
        return (String)MBEAN_POSTFIXES.find(name::endsWith).fold(() -> name, p -> name.substring(0, name.length() - p.length()));
    }

    public static String strippedName(Class<?> clazz) {
        return ObjectNames.strippedName(clazz.getCanonicalName());
    }

    public static String typeName(Class<?> clazz) {
        return ObjectNames.typeName(clazz, false);
    }

    public static String typeName(Class<?> clazz, boolean verbatim) {
        String n = Classes.outermost(clazz).getSimpleName();
        return verbatim ? n : ObjectNames.strippedName(n);
    }

    public static String typeName(String qualifiedName) {
        return ObjectNames.typeName(qualifiedName, false);
    }

    public static String typeName(String qualifiedName, boolean verbatim) {
        int pos = qualifiedName.lastIndexOf(46);
        String n = pos < 0 ? ObjectNames.strippedName(qualifiedName) : ObjectNames.strippedName(qualifiedName.substring(pos + 1));
        return verbatim ? n : ObjectNames.strippedName(n);
    }

    public static Class<?> typeGivingClass(Class<?> clazz) {
        return Classes.outermost(clazz);
    }

    public static String quoteIfNecessary(String component) {
        return ObjectNames.shouldQuote(component) ? ObjectName.quote(component) : component;
    }

    public static boolean shouldQuote(String component) {
        if (component.isEmpty()) {
            return true;
        }
        for (int i = 0; i < component.length(); ++i) {
            char c = component.charAt(i);
            if (SPECIAL_NAME_CHARS.indexOf(c) < 0 && !Character.isWhitespace(c)) continue;
            return true;
        }
        return false;
    }

    public static String packageName(String qualifiedName) {
        return ObjectNames.packageName(qualifiedName, 0);
    }

    public static String packageName(Class<?> clazz) {
        return ObjectNames.packageName(clazz, 0);
    }

    public static String packageName(Class<?> clazz, int up) {
        return ObjectNames.packageName(clazz.getName(), up);
    }

    public static String packageName(String qualifiedName, int up) {
        if (qualifiedName.isEmpty()) {
            throw new IllegalArgumentException("Empty qualified name");
        }
        int pos = qualifiedName.lastIndexOf(46);
        ObjectNames.checkQNamePos(qualifiedName, pos, 0);
        for (int i = 0; i < up; ++i) {
            pos = qualifiedName.lastIndexOf(46, pos - 1);
            ObjectNames.checkQNamePos(qualifiedName, pos, i);
        }
        return qualifiedName.substring(0, pos);
    }

    private static void checkQNamePos(String qualifiedName, int pos, int depth) {
        if (pos <= 0) {
            throw new IllegalArgumentException("Empty package name for qualified name '" + qualifiedName + "' at " + depth);
        }
    }
}

