/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.base.jmx.registry.std;

import ch.raffael.meldioc.library.base.jmx.registry.MBeanRegistry;
import ch.raffael.meldioc.library.base.jmx.registry.RegistrationBuilder;
import ch.raffael.meldioc.library.base.jmx.registry.std.AbstractRegistrationBuilder;
import ch.raffael.meldioc.library.base.jmx.registry.util.DomainMappings;
import ch.raffael.meldioc.logging.Logging;
import io.vavr.control.Option;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;

public class DefaultMBeanRegistry
implements MBeanRegistry {
    private static final Logger LOG = Logging.logger();
    private final IdentityHashMap<Object, Registration> registrations = new IdentityHashMap();
    private final MBeanServer server;
    private final DomainMappings domainMappings;
    private final ReadWriteLock shutdownLock = new ReentrantReadWriteLock();
    private boolean shutdown = false;

    protected DefaultMBeanRegistry(MBeanServer server, DomainMappings domainMappings) {
        this.server = server;
        this.domainMappings = domainMappings;
    }

    public static Handle create(MBeanServer server, DomainMappings domainMappings) {
        return new Handle(new DefaultMBeanRegistry(server, domainMappings));
    }

    @Override
    public RegistrationBuilder registrationBuilder() {
        this.checkNotShutdown();
        return new MyRegistrationBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Option<ObjectName> nameOf(Object object) {
        IdentityHashMap<Object, Registration> identityHashMap = this.registrations;
        synchronized (identityHashMap) {
            return Option.of((Object)this.registrations.get(object)).flatMap(r -> Option.of((Object)r.objectName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unregister(Object object) throws MBeanRegistrationException {
        Registration reg = this.claimRegistration(object, false);
        if (reg == null) {
            return false;
        }
        reg.lock.lock();
        try {
            if (reg.objectName == null) {
                boolean bl = false;
                return bl;
            }
            try {
                LOG.debug("Unregistering MBean: {}", (Object)reg);
                this.server.unregisterMBean(reg.objectName);
                reg.objectName = null;
            }
            catch (InstanceNotFoundException e) {
                LOG.warn("Instance of registered MBean not found: {}", (Object)reg, (Object)e);
                reg.objectName = null;
                boolean bl = false;
                reg.lock.unlock();
                this.releaseRegistration(reg);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            reg.lock.unlock();
            this.releaseRegistration(reg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void shutdown() {
        this.shutdownLock.writeLock().lock();
        try {
            if (this.shutdown) {
                return;
            }
            IdentityHashMap<Object, Registration> identityHashMap = this.registrations;
            synchronized (identityHashMap) {
                while (!this.registrations.isEmpty()) {
                    Registration reg = this.registrations.entrySet().iterator().next().getValue();
                    try {
                        this.unregister(reg.key);
                    }
                    catch (Exception e) {
                        LOG.error("Error unregistering {}", (Object)reg);
                    }
                }
                return;
            }
        }
        finally {
            this.shutdown = true;
            this.shutdownLock.writeLock().lock();
        }
    }

    private void checkNotShutdown() {
        this.shutdownLock.readLock().lock();
        try {
            if (this.shutdown) {
                throw new IllegalStateException("Shutdown");
            }
        }
        finally {
            this.shutdownLock.readLock().unlock();
        }
    }

    @Override
    public MBeanRegistry withDefaultDomain(String name) {
        return new DefaultMBeanRegistry(this.server, this.domainMappings.withDefaultDomain(name));
    }

    @Override
    public MBeanRegistry withFixedDomain(String name) {
        return new DefaultMBeanRegistry(this.server, DomainMappings.of(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Registration claimRegistration(Object key, boolean create) {
        IdentityHashMap<Object, Registration> identityHashMap = this.registrations;
        synchronized (identityHashMap) {
            Registration reg = this.registrations.get(key);
            if (reg == null && create) {
                reg = new Registration(key);
                this.registrations.put(key, reg);
            }
            if (reg != null) {
                ++reg.claimedCount;
            }
            return reg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseRegistration(Registration reg) {
        IdentityHashMap<Object, Registration> identityHashMap = this.registrations;
        synchronized (identityHashMap) {
            --reg.claimedCount;
            if (reg.claimedCount <= 0 && reg.objectName == null) {
                this.registrations.remove(reg.key);
            }
        }
    }

    private static final class Registration {
        private final Object key;
        private final ReentrantLock lock = new ReentrantLock();
        private int claimedCount = 0;
        @Nullable
        private ObjectName objectName;

        private Registration(Object key) {
            this.key = key;
        }

        public String toString() {
            return this.objectName + " -> " + this.key;
        }
    }

    private class MyRegistrationBuilder
    extends AbstractRegistrationBuilder<Registration> {
        public MyRegistrationBuilder() {
            super(LOG, DefaultMBeanRegistry.this.domainMappings);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Registration preRegister(Object key) {
            DefaultMBeanRegistry.this.checkNotShutdown();
            Objects.requireNonNull(key, "key");
            Registration reg = DefaultMBeanRegistry.this.claimRegistration(key, true);
            assert (reg != null);
            reg.lock.lock();
            boolean success = false;
            try {
                if (reg.objectName != null) {
                    throw new IllegalStateException("MBean registration already present for " + key + " as " + reg.objectName);
                }
                success = true;
                Registration registration = reg;
                return registration;
            }
            finally {
                if (!success) {
                    reg.lock.unlock();
                    DefaultMBeanRegistry.this.releaseRegistration(reg);
                }
            }
        }

        @Override
        protected void postRegister(Registration reg) {
            assert (reg.lock.isHeldByCurrentThread());
            reg.lock.unlock();
            DefaultMBeanRegistry.this.releaseRegistration(reg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doRegister(Registration reg, Object mbean, ObjectName objectName) throws Exception {
            assert (reg.lock.isHeldByCurrentThread());
            DefaultMBeanRegistry.this.shutdownLock.readLock().lock();
            try {
                DefaultMBeanRegistry.this.checkNotShutdown();
                DefaultMBeanRegistry.this.server.registerMBean(mbean, objectName);
                reg.objectName = objectName;
            }
            finally {
                DefaultMBeanRegistry.this.shutdownLock.readLock().unlock();
            }
        }
    }

    public static class Handle {
        private final DefaultMBeanRegistry registry;

        protected Handle(DefaultMBeanRegistry registry) {
            this.registry = registry;
        }

        public DefaultMBeanRegistry registry() {
            return this.registry;
        }

        public void shutdown() {
            this.registry.shutdown();
        }

        public String toString() {
            return "Handle<" + this.registry.toString() + ">";
        }
    }
}

