/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.base.threading;

import ch.raffael.meldioc.Feature;
import ch.raffael.meldioc.Provision;
import ch.raffael.meldioc.library.base.lifecycle.ShutdownController;
import ch.raffael.meldioc.library.base.lifecycle.ShutdownFeature;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;

@Feature
public interface ThreadingFeature {
    @Provision
    public ExecutorService workExecutor();

    @Provision
    default public ForkJoinPool forkJoinPool() {
        return ForkJoinPool.commonPool();
    }

    public static final class Util {
        public static <T extends ExecutorService> T applyExecutorServiceShutdown(T executorService, ShutdownFeature shutdownFeature) {
            Util.applyExecutorServiceShutdown(executorService, shutdownFeature.shutdownController());
            return executorService;
        }

        public static <T extends ExecutorService> T applyExecutorServiceShutdown(T executorService, ShutdownController shutdownFeature) {
            shutdownFeature.onFinalize(executorService::shutdownNow);
            return executorService;
        }
    }

    @Deprecated(forRemoval=true)
    @Feature
    public static abstract class WithSystemForkJoinPool
    implements ThreadingFeature {
        @Override
        @Provision
        public ForkJoinPool forkJoinPool() {
            return ForkJoinPool.commonPool();
        }
    }
}

