/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.base;

import ch.raffael.meldioc.library.base.lifecycle.ShutdownController;
import ch.raffael.meldioc.logging.Logging;
import io.vavr.collection.Array;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public final class ShutdownHooks {
    private static final Logger LOG = Logging.logger();
    private static final Object LOCK = new Object();
    @Nullable
    private static volatile ShutdownHooks INSTANCE = null;
    private final Thread shutdownHook = new Thread(ShutdownHooks.class.getName()){

        @Override
        public void run() {
            ShutdownHooks.this.hooks.get().forEach(Runnable::run);
            if (ShutdownHooks.this.shutdownLogging) {
                Logging.shutdown();
            }
        }
    };
    private final AtomicReference<Seq<Runnable>> hooks = new AtomicReference<List>(List.empty());
    private volatile boolean shutdownLogging = true;

    private ShutdownHooks() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShutdownHooks shutdownHooks() {
        ShutdownHooks i = INSTANCE;
        if (i == null) {
            Object object = LOCK;
            synchronized (object) {
                i = INSTANCE;
                if (i == null) {
                    i = new ShutdownHooks();
                    Runtime.getRuntime().addShutdownHook(i.shutdownHook);
                    INSTANCE = i;
                    LOG.trace("Shutdown hook installed");
                }
            }
        }
        return i;
    }

    public ShutdownHooks add(Runnable ... runnable) {
        this.hooks.updateAndGet(r -> r.appendAll((Iterable)Array.of((Object[])runnable)));
        return this;
    }

    public ShutdownHooks add(Supplier<? extends ShutdownController.Actuator> shutdownHandleSupplier) {
        return this.add(() -> {
            ShutdownController.Actuator actuator = (ShutdownController.Actuator)shutdownHandleSupplier.get();
            try {
                actuator.performShutdown();
            }
            catch (Throwable e) {
                LOG.error("Error shutting down (current state: {})", (Object)actuator.state(), (Object)e);
            }
        });
    }

    @Deprecated
    public ShutdownHooks logging() {
        this.shutdownLogging = true;
        return this;
    }

    public ShutdownHooks shutdownLogging(boolean shutdownLogging) {
        this.shutdownLogging = shutdownLogging;
        return this;
    }
}

