/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.base.threading;

import io.vavr.Function1;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class CountingThreadFactory
implements ThreadFactory {
    private final Option<ThreadGroup> group;
    private final Function1<Integer, String> nameBuilder;
    private final AtomicInteger counter = new AtomicInteger();

    public CountingThreadFactory(Function1<Integer, String> nameBuilder) {
        this((Option<ThreadGroup>)Option.none(), nameBuilder);
    }

    public CountingThreadFactory(ThreadGroup group, Function1<Integer, String> nameBuilder) {
        this((Option<ThreadGroup>)Option.some((Object)group), nameBuilder);
    }

    public CountingThreadFactory(String nameFormat) {
        this((Option<ThreadGroup>)Option.none(), CountingThreadFactory.formatNameBuilder(nameFormat));
    }

    public CountingThreadFactory(ThreadGroup group, String nameFormat) {
        this((Option<ThreadGroup>)Option.some((Object)group), CountingThreadFactory.formatNameBuilder(nameFormat));
    }

    public CountingThreadFactory(Option<ThreadGroup> group, Function1<Integer, String> nameBuilder) {
        this.group = group;
        this.nameBuilder = nameBuilder;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        return new Thread((ThreadGroup)this.group.getOrNull(), runnable, (String)this.nameBuilder.apply((Object)this.counter.getAndIncrement()));
    }

    public static Function1<Integer, String> formatNameBuilder(String format) {
        return (Function1 & Serializable)i -> String.format(format, i);
    }
}

