/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.base.threading;

import ch.raffael.meldioc.Feature;
import ch.raffael.meldioc.Parameter;
import ch.raffael.meldioc.Provision;
import ch.raffael.meldioc.library.base.lifecycle.ShutdownFeature;
import ch.raffael.meldioc.library.base.threading.AbstractThreadingFeature;
import ch.raffael.meldioc.library.base.threading.CountingThreadFactory;
import ch.raffael.meldioc.library.base.threading.ThreadingFeature;
import io.vavr.control.Option;
import java.time.Duration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Feature
@Parameter.Prefix(value="workers")
public abstract class JavaThreadPoolFeature
extends AbstractThreadingFeature.WithTaskAdvice {
    @Parameter
    protected int corePoolSize() {
        return 5;
    }

    @Parameter
    protected int maxPoolSize() {
        return 20;
    }

    @Parameter
    protected Duration keepAliveTime() {
        return Duration.ofSeconds(2L);
    }

    @Parameter
    protected int queueCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    @Provision(singleton=true)
    protected ExecutorService workExecutorImplementation() {
        return (ExecutorService)this.createRejectedExecutionHandler().map(reh -> new ThreadPoolExecutor(this.corePoolSize(), this.maxPoolSize(), this.keepAliveTime().toMillis(), TimeUnit.MILLISECONDS, this.createQueue(), this.createThreadFactory(), (RejectedExecutionHandler)reh)).getOrElse(() -> new ThreadPoolExecutor(this.corePoolSize(), this.maxPoolSize(), this.keepAliveTime().toMillis(), TimeUnit.MILLISECONDS, this.createQueue(), this.createThreadFactory()));
    }

    protected BlockingQueue<Runnable> createQueue() {
        return new LinkedBlockingDeque<Runnable>(this.queueCapacity());
    }

    protected ThreadFactory createThreadFactory() {
        return new CountingThreadFactory(this.threadGroup(), CountingThreadFactory.formatNameBuilder("worker-%d"));
    }

    protected Option<ThreadGroup> threadGroup() {
        return Option.some((Object)new ThreadGroup("workers"));
    }

    protected Option<? extends RejectedExecutionHandler> createRejectedExecutionHandler() {
        return Option.none();
    }

    @Feature
    public static abstract class WithShutdown
    extends JavaThreadPoolFeature
    implements ShutdownFeature {
        @Override
        @Provision(singleton=true)
        protected ExecutorService workExecutorImplementation() {
            return ThreadingFeature.Util.applyExecutorServiceShutdown(super.workExecutorImplementation(), this);
        }
    }
}

