/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.base.lifecycle;

import ch.raffael.meldioc.Provision;
import ch.raffael.meldioc.library.base.ShutdownHooks;
import ch.raffael.meldioc.library.base.lifecycle.ExecutorShutdownController;
import ch.raffael.meldioc.library.base.lifecycle.ShutdownController;
import ch.raffael.meldioc.library.base.lifecycle.ShutdownFeature;
import ch.raffael.meldioc.library.base.lifecycle.Startup;
import ch.raffael.meldioc.library.base.lifecycle.StartupActions;
import ch.raffael.meldioc.library.base.threading.ThreadingFeature;
import io.vavr.CheckedRunnable;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.collection.Traversable;
import io.vavr.control.Option;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class Lifecycle {
    private static final ShutdownController.Actuator NULL_SHUTDOWN_ACTUATOR = new ShutdownController.Actuator(){

        @Override
        public ShutdownController controller() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T getPreventingShutdown(Supplier<T> supplier) {
            return supplier.get();
        }

        @Override
        public void announceShutdown() {
        }

        @Override
        public Seq<Throwable> performShutdown() {
            return List.empty();
        }
    };
    private final Supplier<? extends Traversable<? extends CheckedRunnable>> startupActions;
    private final Supplier<? extends Executor> executor;
    private final Supplier<? extends ShutdownController.Actuator> shutdownActuator;
    private final Instant createTimestamp;
    private boolean asApplication = false;
    private Consumer<StartupSuccess> onSuccess = __ -> {};
    private Consumer<StartupError> onError = __ -> {};
    private Option<Integer> exitOnError = Option.none();

    protected Lifecycle(Supplier<? extends Traversable<? extends CheckedRunnable>> startupActions, Supplier<? extends Executor> executor, Supplier<? extends ShutdownController.Actuator> shutdownActuator, Instant createTimestamp) {
        this.startupActions = startupActions;
        this.executor = executor;
        this.shutdownActuator = shutdownActuator;
        this.createTimestamp = createTimestamp;
    }

    public static Lifecycle of(Supplier<? extends Executor> executor, Supplier<? extends Traversable<? extends CheckedRunnable>> startupActions, Supplier<? extends ShutdownController.Actuator> shutdownActuator) {
        return new Lifecycle(startupActions, executor, shutdownActuator, Instant.now());
    }

    public static Lifecycle of(Supplier<? extends Executor> executor, StartupActions.Feature startupActionsFeature, ShutdownFeature.WithActuator shutdownFeature) {
        return Lifecycle.of(executor, startupActionsFeature.startupActionsEP()::startupActions, shutdownFeature::shutdownActuator);
    }

    public static Lifecycle of(ThreadingFeature threadingFeature, StartupActions.Feature startupActionsFeature, ShutdownFeature.WithActuator shutdownFeature) {
        return Lifecycle.of(threadingFeature::workExecutor, startupActionsFeature.startupActionsEP()::startupActions, shutdownFeature::shutdownActuator);
    }

    public static Lifecycle of(Feature lifecycleFeature) {
        return Lifecycle.of(lifecycleFeature::workExecutor, lifecycleFeature.startupActionsEP()::startupActions, lifecycleFeature::shutdownActuator);
    }

    public static ShutdownController.Actuator nullShutdownActuator() {
        return NULL_SHUTDOWN_ACTUATOR;
    }

    public Lifecycle onSuccess(Consumer<? super StartupSuccess> onSuccess) {
        this.onSuccess = this.onSuccess.andThen(onSuccess);
        return this;
    }

    public Lifecycle onError(Consumer<? super StartupError> onError) {
        this.onError = this.onError.andThen(onError);
        return this;
    }

    public Lifecycle log(Logger log) {
        this.onSuccess(r -> {
            if (log.isInfoEnabled()) {
                log.info("Startup completed successfully in {}", (Object)r.timingInfoString());
            }
        });
        this.onError(err -> {
            if (!err.errors().isEmpty() && log.isErrorEnabled()) {
                log.error("Startup completed with errors in {}: {}", (Object)err.timingInfoString(), err.errors());
            }
            err.failure().forEach(e -> {
                if (log.isErrorEnabled()) {
                    log.error("Startup failed after {}", (Object)err.timingInfoString(), e);
                }
            });
        });
        return this;
    }

    public Lifecycle asApplication(Logger log) {
        return this.asApplication((Option<? extends Logger>)Option.some((Object)log));
    }

    public Lifecycle asApplication(Option<? extends Logger> log) {
        this.asApplication = true;
        log.forEach(this::log);
        this.shutdownHook();
        this.exitOnError();
        return this;
    }

    public Lifecycle shutdownHook() {
        ShutdownHooks.shutdownHooks().add(this.shutdownActuator);
        return this;
    }

    public Lifecycle exitOnError() {
        return this.exitOnError(1);
    }

    public Lifecycle exitOnError(int exitCode) {
        this.exitOnError = Option.some((Object)exitCode);
        return this;
    }

    public StartupResult start() {
        return this.start(0L);
    }

    public StartupResult start(long timeoutSeconds) {
        return this.start(timeoutSeconds, TimeUnit.SECONDS);
    }

    public StartupResult start(long timeout, TimeUnit timeoutUnit) {
        Seq<Throwable> errors;
        try {
            errors = new Startup(this.startupActions.get(), this.executor.get(), this.shutdownActuator.get()).start(timeout, timeoutUnit);
        }
        catch (InterruptedException | TimeoutException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            return this.doOnError(new StartupError(e));
        }
        if (errors.isEmpty()) {
            StartupSuccess success = new StartupSuccess();
            this.onSuccess.accept(success);
            return success;
        }
        return this.doOnError(new StartupError(errors));
    }

    public Seq<Throwable> shutdown() throws InterruptedException {
        return this.shutdownActuator.get().performShutdown();
    }

    private StartupError doOnError(StartupError error) {
        try {
            this.onError.accept(error);
            StartupError startupError = error;
            return startupError;
        }
        finally {
            if (this.exitOnError.isDefined()) {
                System.exit((Integer)this.exitOnError.get());
            }
        }
    }

    @Deprecated(forRemoval=true)
    public static class LegacyLifecycle
    extends Lifecycle {
        protected LegacyLifecycle(Supplier<? extends Traversable<? extends CheckedRunnable>> startupActions, Supplier<? extends Executor> executor, Supplier<? extends ShutdownController.Actuator> shutdownActuator, Instant createTimestamp) {
            super(startupActions, executor, shutdownActuator, createTimestamp);
        }
    }

    @ch.raffael.meldioc.Feature
    public static abstract class Feature
    extends StartupActions.Feature
    implements ThreadingFeature,
    ShutdownFeature.WithActuator {
        @Override
        @Provision(singleton=true)
        public ShutdownController.Actuator shutdownActuator() {
            return new ExecutorShutdownController(this::workExecutor).actuator();
        }
    }

    public final class StartupError
    extends StartupResult {
        private StartupError(Seq<Throwable> errors) {
            super(false, errors, (Option<Throwable>)Option.none());
        }

        private StartupError(Throwable failure) {
            super(false, (Seq<Throwable>)List.empty(), (Option<Throwable>)Option.some((Object)failure));
        }
    }

    public final class StartupSuccess
    extends StartupResult {
        private StartupSuccess() {
            super(true, (Seq<Throwable>)List.empty(), (Option<Throwable>)Option.none());
        }
    }

    public abstract class StartupResult {
        private final boolean success;
        private final Seq<Throwable> errors;
        private final Option<Throwable> failure;
        private final Duration duration;

        private StartupResult(boolean success, Seq<Throwable> errors, Option<Throwable> failure) {
            this.duration = Duration.between(Lifecycle.this.createTimestamp, Instant.now());
            this.success = success;
            this.errors = errors;
            this.failure = failure;
        }

        public boolean success() {
            return this.success;
        }

        public Seq<Throwable> errors() {
            return this.errors;
        }

        public Option<Throwable> failure() {
            return this.failure;
        }

        public Duration duration() {
            return this.duration;
        }

        public Duration jvmUptime() {
            return Duration.ofMillis(ManagementFactory.getRuntimeMXBean().getUptime());
        }

        public String timingInfoString() {
            return this.timingInfoString(Lifecycle.this.asApplication);
        }

        public String timingInfoString(boolean jvmUptime) {
            return jvmUptime ? this.duration() + " (JVM uptime " + this.jvmUptime() + ")" : this.duration().toString();
        }
    }
}

