/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.base.threading;

import ch.raffael.meldioc.ExtensionPoint;
import ch.raffael.meldioc.Feature;
import ch.raffael.meldioc.Provision;
import ch.raffael.meldioc.library.base.threading.DefaultWorkExecutorProvider;
import ch.raffael.meldioc.library.base.threading.TaskAdviceFeature;
import ch.raffael.meldioc.library.base.threading.ThreadingFeature;
import ch.raffael.meldioc.util.advice.AroundAdvice;
import java.util.concurrent.ExecutorService;

@Feature
public abstract class AbstractThreadingFeature
implements ThreadingFeature {
    protected final DefaultWorkExecutorProvider workExecutorProvider = new DefaultWorkExecutorProvider(this::workExecutorImplementation);

    protected AbstractThreadingFeature() {
    }

    @Override
    @Provision(singleton=true)
    public ExecutorService workExecutor() {
        return this.workExecutorProvider.workExecutor();
    }

    @Deprecated(forRemoval=true)
    @Provision(singleton=true)
    protected ExecutorService unrestrictedWorkExecutor() {
        throw new UnsupportedOperationException();
    }

    @Provision(singleton=true)
    protected ExecutorService workExecutorImplementation() {
        return this.unrestrictedWorkExecutor();
    }

    @Feature
    public static class WithTaskAdvice
    extends AbstractThreadingFeature
    implements TaskAdviceFeature {
        @Override
        @Provision(singleton=true)
        public AroundAdvice taskAdvice() {
            return this.workExecutorProvider.taskAdvice();
        }

        @ExtensionPoint
        protected TaskAdviceFeature.Profile taskAdviceProfile() {
            return this.workExecutorProvider.taskAdviceProfile();
        }
    }
}

