/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.base.lifecycle;

import ch.raffael.meldioc.library.base.lifecycle.ShutdownController;
import io.vavr.CheckedRunnable;
import io.vavr.Lazy;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorShutdownController
implements ShutdownController,
ShutdownController.Actuator {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorShutdownController.class);
    private final Lazy<Executor> executor;
    private Seq<CheckedRunnable> prepareCallbacks = List.empty();
    private Seq<CheckedRunnable> performCallbacks = List.empty();
    private Seq<CheckedRunnable> finalizeCallbacks = List.empty();
    private final Object sync = new Object();
    private volatile ShutdownController.State state = ShutdownController.State.DORMANT;
    private int preventDepth = 0;
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private final AtomicReference<Seq<Throwable>> shutdownErrors = new AtomicReference<Object>(null);
    private final ShutdownController isolatedController = new ShutdownController.Wrapper(this);

    public ExecutorShutdownController(Supplier<? extends Executor> executor) {
        this.executor = Lazy.of(executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPrepare(CheckedRunnable callback) {
        Object object = this.sync;
        synchronized (object) {
            this.state.checkStateBefore(ShutdownController.State.PREPARING);
            this.prepareCallbacks = this.prepareCallbacks.prepend((Object)callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPerform(CheckedRunnable callback) {
        Object object = this.sync;
        synchronized (object) {
            this.state.checkStateBefore(ShutdownController.State.PERFORMING);
            this.performCallbacks = this.performCallbacks.prepend((Object)callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFinalize(CheckedRunnable callback) {
        Object object = this.sync;
        synchronized (object) {
            this.state.checkStateBefore(ShutdownController.State.FINALIZING);
            this.finalizeCallbacks = this.finalizeCallbacks.prepend((Object)callback);
        }
    }

    @Override
    public ShutdownController controller() {
        return this.isolatedController;
    }

    @Override
    public ShutdownController.State state() {
        return this.state;
    }

    public ExecutorShutdownController actuator() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getPreventingShutdown(Supplier<T> supplier) {
        Object object = this.sync;
        synchronized (object) {
            this.state.checkStateBeforeOrEqual(ShutdownController.State.DORMANT);
            ++this.preventDepth;
        }
        try {
            object = supplier.get();
            return (T)object;
        }
        finally {
            Object object2 = this.sync;
            synchronized (object2) {
                --this.preventDepth;
                this.sync.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void announceShutdown() {
        Object object = this.sync;
        synchronized (object) {
            if (this.state.isBefore(ShutdownController.State.ANNOUNCED)) {
                this.state = ShutdownController.State.ANNOUNCED;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Seq<Throwable> performShutdown() throws InterruptedException {
        Object object = this.sync;
        synchronized (object) {
            if (this.state.isBefore(ShutdownController.State.INITIATED)) {
                this.state = ShutdownController.State.INITIATED;
            }
            boolean preventLogged = false;
            while (this.preventDepth > 0) {
                if (preventLogged) {
                    LOG.trace("Awaiting {} more shutdown preventing actions", (Object)this.preventDepth);
                } else {
                    LOG.debug("Awaiting {} shutdown preventing actions", (Object)this.preventDepth);
                    preventLogged = true;
                }
                try {
                    this.sync.wait();
                }
                catch (InterruptedException e) {
                    throw new InterruptedException("Interrupted while waiting for shutdown preventing actions to finish");
                }
            }
            if (this.shutdownErrors.compareAndSet(null, (Seq<Throwable>)List.empty())) {
                assert (this.state == ShutdownController.State.INITIATED);
                this.doShutdown();
            }
        }
        try {
            this.shutdownLatch.await();
        }
        catch (InterruptedException e) {
            throw new InterruptedException("Interrupted while awaiting shutdown completion (state: " + this.state() + ")");
        }
        return Objects.requireNonNull(this.shutdownErrors.get(), "shutdownErrors.get()");
    }

    protected void onShutdownComplete(Seq<Throwable> exceptions) {
        if (exceptions.isEmpty()) {
            LOG.info("Shutdown completed successfully");
        } else {
            LOG.error("Shutdown completed with errors: {}", exceptions);
        }
    }

    protected void onDoShutdown() {
        LOG.info("Performing shutdown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doShutdown() throws InterruptedException {
        try {
            Seq<CheckedRunnable> callbacks;
            this.onDoShutdown();
            Object object = this.sync;
            synchronized (object) {
                this.state = ShutdownController.State.PREPARING;
                callbacks = this.prepareCallbacks;
            }
            this.runCallbacks((Executor)this.executor.get(), "prepare", callbacks);
            object = this.sync;
            synchronized (object) {
                this.state = ShutdownController.State.PERFORMING;
                callbacks = this.performCallbacks;
            }
            this.runCallbacks((Executor)this.executor.get(), "perform", callbacks);
            object = this.sync;
            synchronized (object) {
                this.state = ShutdownController.State.FINALIZING;
                callbacks = this.finalizeCallbacks;
            }
            this.runCallbacks(Runnable::run, "finalize", callbacks);
            this.onShutdownComplete(this.shutdownErrors.get());
        }
        finally {
            this.state = ShutdownController.State.COMPLETE;
            this.shutdownLatch.countDown();
        }
    }

    private void runCallbacks(Executor executor, String phase, Seq<CheckedRunnable> callbacks) throws InterruptedException {
        if (!callbacks.isEmpty()) {
            CountDownLatch latch = new CountDownLatch(callbacks.size());
            callbacks.forEach(cb -> executor.execute(() -> {
                try {
                    cb.run();
                }
                catch (Throwable e) {
                    LOG.error("Shutdown {} callback failed: {}", new Object[]{phase, cb, e});
                    this.shutdownErrors.updateAndGet(s -> s.append((Object)e));
                }
                finally {
                    latch.countDown();
                }
            }));
            latch.await();
        }
    }
}

