/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.base.jmx.registry;

import ch.raffael.meldioc.ExtensionPoint;
import ch.raffael.meldioc.Feature;
import ch.raffael.meldioc.Provision;
import ch.raffael.meldioc.library.base.jmx.registry.MBeanRegistry;
import ch.raffael.meldioc.library.base.jmx.registry.std.DefaultMBeanRegistry;
import ch.raffael.meldioc.library.base.jmx.registry.util.DomainMappings;
import ch.raffael.meldioc.library.base.lifecycle.ShutdownFeature;
import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;

@Feature
public interface MBeanRegistryFeature {
    @Provision
    public MBeanServer registryMBeanServer();

    @Provision
    public MBeanRegistry mbeanRegistry();

    @ExtensionPoint
    public static class Configuration {
        private Option<String> defaultDomain = Option.none();
        private Map<String, String> mappings = LinkedHashMap.empty();

        public Configuration defaultDomain(String defaultDomain) {
            this.defaultDomain = Option.some((Object)defaultDomain);
            return this;
        }

        public Configuration mapping(String baseName, String domain) {
            this.mappings = this.mappings.put((Object)baseName, (Object)domain);
            return this;
        }

        public DomainMappings toMappings() {
            return DomainMappings.builder().defaultDomain((String)this.defaultDomain.getOrElseThrow(() -> new IllegalStateException("No default domain set"))).mappings((Map)this.mappings).build();
        }
    }

    @Feature
    public static abstract class WithShutdown
    extends Default
    implements ShutdownFeature {
        @Override
        protected void postCreate(DefaultMBeanRegistry.Handle registryHandle) {
            super.postCreate(registryHandle);
            this.shutdownController().onPerform(registryHandle::shutdown);
        }
    }

    @Feature
    public static abstract class Default
    implements MBeanRegistryFeature {
        private final Configuration configuration = new Configuration();

        @ExtensionPoint
        protected Configuration configuration() {
            return this.configuration;
        }

        @Override
        @Provision(singleton=true)
        public DefaultMBeanRegistry mbeanRegistry() {
            DefaultMBeanRegistry.Handle handle = DefaultMBeanRegistry.create(this.registryMBeanServer(), this.configuration.toMappings());
            this.postCreate(handle);
            return handle.registry();
        }

        protected void postCreate(DefaultMBeanRegistry.Handle registryHandle) {
        }
    }

    @Feature
    public static abstract class UsePlatformMBeanServer
    implements MBeanRegistryFeature {
        @Override
        @Provision(singleton=true)
        public MBeanServer registryMBeanServer() {
            return ManagementFactory.getPlatformMBeanServer();
        }
    }
}

