/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.base.jmx.registry.std;

import ch.raffael.meldioc.library.base.jmx.registry.MBeanRegistry;
import ch.raffael.meldioc.library.base.jmx.registry.RegistrationBuilder;
import ch.raffael.meldioc.library.base.jmx.registry.std.DefaultObjectNameBuilder;
import ch.raffael.meldioc.library.base.jmx.registry.util.DomainMappings;
import ch.raffael.meldioc.library.base.jmx.registry.util.ObjectNames;
import ch.raffael.meldioc.util.Exceptions;
import io.vavr.control.Option;
import java.util.Map;
import java.util.function.Consumer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;

public abstract class AbstractRegistrationBuilder<S>
implements RegistrationBuilder {
    private final Logger logger;
    private final DefaultObjectNameBuilder nameBuilder = new DefaultObjectNameBuilder();
    private final DomainMappings mappings;
    private Option<Consumer<? super Throwable>> errorHandler = Option.none();
    private boolean verbatimType = false;
    private boolean skipTypeProperty = false;

    public AbstractRegistrationBuilder(Logger logger, DomainMappings mappings) {
        this.logger = logger;
        this.mappings = mappings;
    }

    @Override
    public RegistrationBuilder type(String type) {
        this.nameBuilder.type(type);
        return this;
    }

    @Override
    public RegistrationBuilder type(Class<?> type, boolean verbatim) {
        this.nameBuilder.type((Class)type, verbatim);
        return this;
    }

    @Override
    public RegistrationBuilder clearType() {
        this.skipTypeProperty = true;
        return this;
    }

    @Override
    public RegistrationBuilder name(String name) {
        this.nameBuilder.name(name);
        return this;
    }

    @Override
    public RegistrationBuilder property(String key, String value) {
        this.nameBuilder.property(key, value);
        return this;
    }

    @Override
    public RegistrationBuilder properties(io.vavr.collection.Map<String, String> properties) {
        this.nameBuilder.properties((io.vavr.collection.Map)properties);
        return this;
    }

    @Override
    public RegistrationBuilder properties(Map<String, String> properties) {
        this.nameBuilder.properties((Map)properties);
        return this;
    }

    @Override
    public RegistrationBuilder domain(String domain) {
        this.nameBuilder.domain(domain);
        return this;
    }

    @Override
    public RegistrationBuilder onError(Consumer<? super Throwable> errorHandler) {
        this.errorHandler = Option.some(errorHandler);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T register(MBeanRegistry.MBeanFactory<? super T> factory, T managed) {
        S state = this.preRegister(managed);
        try {
            Object mbean = factory.mbeanFor(managed);
            ObjectName objectName = this.toObjectName(managed);
            this.logger.debug("Registering MBean {} for {} as {}", new Object[]{mbean, managed, objectName});
            this.doRegister(state, mbean, objectName);
        }
        catch (Exception e) {
            this.logger.error("Error registering MBean for {}", managed, (Object)e);
            if (this.errorHandler.isDefined()) {
                try {
                    ((Consumer)this.errorHandler.get()).accept(e);
                }
                catch (Throwable e2) {
                    Exceptions.rethrowIfFatal((Throwable)e2, (Throwable)e);
                    e.addSuppressed(e2);
                }
            }
        }
        finally {
            this.postRegister(state);
        }
        return managed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T register(T mbean) {
        S state = this.preRegister(mbean);
        try {
            ObjectName objectName = this.toObjectName(mbean);
            this.logger.debug("Registering MBean {} as {}", mbean, (Object)objectName);
            this.doRegister(state, mbean, objectName);
        }
        catch (Exception e) {
            this.logger.error("Error registering MBean {}", mbean, (Object)e);
            if (this.errorHandler.isDefined()) {
                try {
                    ((Consumer)this.errorHandler.get()).accept(e);
                }
                catch (Throwable e2) {
                    Exceptions.rethrowIfFatal((Throwable)e2, (Throwable)e);
                    e.addSuppressed(e2);
                }
            }
        }
        finally {
            this.postRegister(state);
        }
        return mbean;
    }

    protected abstract S preRegister(Object var1);

    protected abstract void postRegister(S var1);

    protected abstract void doRegister(S var1, Object var2, ObjectName var3) throws Exception;

    @Override
    public ObjectName toObjectName(Object object) throws MalformedObjectNameException {
        if (!this.skipTypeProperty) {
            this.nameBuilder.type((String)this.nameBuilder.type().getOrElse((Object)ObjectNames.typeName(object.getClass(), this.verbatimType)));
        }
        this.nameBuilder.domain((String)this.nameBuilder.domain().getOrElse((Object)this.mappings.domainFor(object.getClass())));
        return this.nameBuilder.toObjectName();
    }

    @Override
    public ObjectName toObjectName() throws MalformedObjectNameException {
        return this.nameBuilder.toObjectName();
    }
}

