/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.base.jmx.registry.std;

import ch.raffael.meldioc.library.base.jmx.registry.ObjectNameBuilder;
import ch.raffael.meldioc.library.base.jmx.registry.util.ObjectNames;
import io.vavr.collection.LinkedHashMap;
import io.vavr.control.Option;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class DefaultObjectNameBuilder
implements ObjectNameBuilder {
    private Option<String> type = Option.none();
    private Option<String> name = Option.none();
    private Option<String> domain = Option.none();
    private io.vavr.collection.Map<String, String> properties = LinkedHashMap.empty();

    @Override
    public DefaultObjectNameBuilder type(String type) {
        this.type = Option.some((Object)type);
        return this;
    }

    @Override
    public DefaultObjectNameBuilder type(Class<?> type, boolean verbatim) {
        this.type = Option.some((Object)ObjectNames.typeName(type, verbatim));
        return this;
    }

    public Option<String> type() {
        return this.type;
    }

    public Option<String> name() {
        return this.name;
    }

    @Override
    public DefaultObjectNameBuilder name(String name) {
        this.name = Option.some((Object)name);
        return this;
    }

    @Override
    public DefaultObjectNameBuilder property(String key, String value) {
        switch (key) {
            case "type": {
                this.type(value);
                break;
            }
            case "name": {
                this.name(value);
                break;
            }
            default: {
                this.properties = this.properties.put((Object)key, (Object)value);
            }
        }
        return this;
    }

    @Override
    public DefaultObjectNameBuilder properties(io.vavr.collection.Map<String, String> properties) {
        properties.forEach(this::property);
        return this;
    }

    @Override
    public DefaultObjectNameBuilder properties(Map<String, String> properties) {
        properties.forEach(this::property);
        return this;
    }

    public io.vavr.collection.Map<String, String> properties() {
        return this.properties;
    }

    @Override
    public DefaultObjectNameBuilder domain(String domain) {
        this.domain = Option.some((Object)domain);
        return this;
    }

    public Option<String> domain() {
        return this.domain;
    }

    @Override
    public ObjectName toObjectName() throws MalformedObjectNameException {
        if (this.type.isEmpty() && this.name.isEmpty() && this.properties.isEmpty()) {
            throw new IllegalStateException("No properties specified");
        }
        StringBuilder objName = new StringBuilder();
        objName.append(ObjectNames.quoteIfNecessary((String)this.domain.getOrElseThrow(() -> new IllegalStateException("No domain specified"))));
        objName.append(":");
        objName.append((String)this.type.map(t -> "type=" + ObjectNames.quoteIfNecessary(t) + ",").getOrElse((Object)""));
        objName.append((String)this.name.map(n -> "name=" + ObjectNames.quoteIfNecessary(n) + ",").getOrElse((Object)""));
        this.properties.forEach((k, v) -> objName.append((String)k).append('=').append(ObjectNames.quoteIfNecessary(v)).append(","));
        if (objName.charAt(objName.length() - 1) == ',') {
            objName.delete(objName.length() - 1, objName.length());
        }
        return new ObjectName(objName.toString());
    }
}

