/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.base.lifecycle;

import io.vavr.CheckedRunnable;
import io.vavr.collection.Seq;
import java.util.function.Supplier;

public interface ShutdownController {
    public void onPrepare(CheckedRunnable var1);

    public void onPerform(CheckedRunnable var1);

    public void onFinalize(CheckedRunnable var1);

    public State state();

    public static class Wrapper
    implements ShutdownController {
        private final ShutdownController delegate;

        public Wrapper(ShutdownController delegate) {
            this.delegate = delegate;
        }

        @Override
        public void onPrepare(CheckedRunnable callback) {
            this.delegate.onPrepare(callback);
        }

        @Override
        public void onPerform(CheckedRunnable callback) {
            this.delegate.onPerform(callback);
        }

        @Override
        public void onFinalize(CheckedRunnable callback) {
            this.delegate.onFinalize(callback);
        }

        @Override
        public State state() {
            return this.delegate.state();
        }

        public String toString() {
            return this.toString() + "[" + String.valueOf(this.delegate) + "]";
        }
    }

    public static class IllegalShutdownStateException
    extends IllegalStateException {
        private final State state;

        public IllegalShutdownStateException(State state) {
            super("Illegal shutdown controller state: " + String.valueOf((Object)state));
            this.state = state;
        }

        public State state() {
            return this.state;
        }
    }

    public static enum State {
        DORMANT,
        ANNOUNCED,
        INITIATED,
        PREPARING,
        PERFORMING,
        FINALIZING,
        COMPLETE;


        public boolean isBefore(State before) {
            return this.ordinal() < before.ordinal();
        }

        public boolean isBeforeOrEqual(State before) {
            return this.ordinal() <= before.ordinal();
        }

        public void checkStateBefore(State before) {
            if (!this.isBefore(before)) {
                throw new IllegalShutdownStateException(this);
            }
        }

        public void checkStateBeforeOrEqual(State before) {
            if (!this.isBeforeOrEqual(before)) {
                throw new IllegalShutdownStateException(this);
            }
        }
    }

    public static interface Actuator {
        public ShutdownController controller();

        default public State state() {
            return this.controller().state();
        }

        default public void runPreventingShutdown(Runnable runnable) {
            this.getPreventingShutdown(() -> {
                runnable.run();
                return null;
            });
        }

        public <T> T getPreventingShutdown(Supplier<T> var1);

        public void announceShutdown();

        public Seq<Throwable> performShutdown() throws InterruptedException;
    }
}

