/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.base.lifecycle;

import ch.raffael.meldioc.library.base.lifecycle.ShutdownController;
import ch.raffael.meldioc.logging.Logging;
import ch.raffael.meldioc.util.Exceptions;
import ch.raffael.meldioc.util.IllegalFlow;
import io.vavr.CheckedRunnable;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.collection.Traversable;
import io.vavr.control.Try;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

public class Startup {
    private static final Logger LOG = Logging.logger();
    private final AtomicReference<CountDownLatch> startupLatch = new AtomicReference<Object>(null);
    public final Traversable<? extends CheckedRunnable> startupActions;
    public final Executor executor;
    public final ShutdownController.Actuator shutdownActuator;

    public Startup(Traversable<? extends CheckedRunnable> startupActions, Executor executor, ShutdownController.Actuator shutdownActuator) {
        this.startupActions = startupActions;
        this.executor = executor;
        this.shutdownActuator = shutdownActuator;
    }

    public Seq<Throwable> start() throws InterruptedException {
        try {
            return this.start(0L);
        }
        catch (TimeoutException e) {
            throw IllegalFlow.unexpectedException((Throwable)e);
        }
    }

    public Seq<Throwable> start(long timeoutSeconds) throws TimeoutException, InterruptedException {
        return this.start(timeoutSeconds, TimeUnit.SECONDS);
    }

    public Seq<Throwable> start(long timeout, TimeUnit timeoutUnit) throws TimeoutException, InterruptedException {
        Seq errors;
        if (this.startupActions.isEmpty()) {
            return List.empty();
        }
        if (!this.startupLatch.compareAndSet(null, new CountDownLatch(1))) {
            throw new IllegalStateException("Startup already initiated");
        }
        try {
            errors = (Seq)this.shutdownActuator.getPreventingShutdown(() -> this.innerStart(this.executor, timeout, timeoutUnit)).get();
        }
        catch (Throwable e) {
            LOG.error("Startup failure, initiating shutdown", e);
            try {
                this.shutdownActuator.performShutdown();
            }
            catch (Throwable e2) {
                Exceptions.rethrowIfFatal((Throwable)e2, (Throwable)e);
                e.addSuppressed(e);
            }
            throw Exceptions.alwaysRethrow((Throwable)e, InterruptedException.class, TimeoutException.class);
        }
        if (!errors.isEmpty()) {
            this.shutdownActuator.performShutdown();
        }
        return errors;
    }

    private Try<Seq<Throwable>> innerStart(Executor executor, long timeout, TimeUnit timeoutUnit) {
        AtomicReference<List> errors = new AtomicReference<List>(List.empty());
        AtomicInteger counter = new AtomicInteger(0);
        this.startupActions.forEach(a -> {
            counter.incrementAndGet();
            executor.execute(() -> this.outerStartupAction(counter, (AtomicReference<Seq<Throwable>>)errors, (CheckedRunnable)a));
        });
        try {
            boolean timedOut;
            if (timeout <= 0L) {
                this.startupLatch.get().await();
                timedOut = false;
            } else {
                boolean bl = timedOut = !this.startupLatch.get().await(timeout, timeoutUnit);
            }
            if (timedOut) {
                return Try.failure((Throwable)new TimeoutException("Timeout awaiting startup completion (" + String.valueOf(Duration.of(timeout, timeoutUnit.toChronoUnit())) + ")"));
            }
            return Try.success((Object)((Seq)errors.get()));
        }
        catch (InterruptedException e) {
            return Try.failure((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outerStartupAction(AtomicInteger counter, AtomicReference<Seq<Throwable>> errors, CheckedRunnable a) {
        try {
            if (!errors.get().isEmpty()) {
                LOG.debug("Skipping startup action {} because startup is being aborted", (Object)a);
            }
            this.shutdownActuator.runPreventingShutdown(() -> this.innerStartupAction(errors, a));
        }
        finally {
            if (counter.decrementAndGet() == 0) {
                this.startupLatch.get().countDown();
            }
        }
    }

    private void innerStartupAction(AtomicReference<Seq<Throwable>> errors, CheckedRunnable a) {
        try {
            a.run();
        }
        catch (Throwable e) {
            try {
                LOG.error("Error in startup action {}", (Object)a, (Object)e);
                errors.updateAndGet(errs -> errs.append((Object)e));
                this.shutdownActuator.announceShutdown();
            }
            catch (Throwable e2) {
                Exceptions.rethrowIfFatal((Throwable)e2, (Throwable)e);
            }
            Exceptions.rethrowIfFatal((Throwable)e);
        }
    }
}

