/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.base.security.ssl;

import io.vavr.Lazy;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class SslContexts {
    private static final Lazy<SSLContext> trustAllSslContext = Lazy.of(SslContexts::createTrustAll);

    private SslContexts() {
    }

    public static SSLContext trustAll() {
        return (SSLContext)trustAllSslContext.get();
    }

    public static SSLContext system() {
        try {
            return SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Error initializing SSL: " + String.valueOf(e), e);
        }
    }

    private static SSLContext createTrustAll() {
        try {
            SSLContext ctx = SSLContext.getInstance("SSL");
            X509TrustManager trustAll = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            ctx.init(null, new TrustManager[]{trustAll}, new SecureRandom());
            return ctx;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to create trust-all SSL context: " + e.toString(), e);
        }
    }
}

