/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.base.threading;

import ch.raffael.meldioc.ExtensionPoint;
import ch.raffael.meldioc.library.base.threading.TaskAdviceFeature;
import ch.raffael.meldioc.util.advice.AdvisingExecutorService;
import ch.raffael.meldioc.util.advice.AroundAdvice;
import ch.raffael.meldioc.util.advice.CompositeAroundAdvice;
import ch.raffael.meldioc.util.concurrent.RestrictedExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.slf4j.MDC;

public class DefaultWorkExecutorProvider {
    private final Supplier<? extends ExecutorService> workExecutorImplementation;
    private final MyTaskAdviceProfile taskAdviceProfile = new MyTaskAdviceProfile();
    private final Supplier<Runnable> defaultTaskFinalizer = () -> this::defaultFinalizeTask;

    public DefaultWorkExecutorProvider(Supplier<? extends ExecutorService> workExecutorImplementation) {
        this.workExecutorImplementation = workExecutorImplementation;
        this.taskAdviceProfile.after(this.defaultTaskFinalizer);
    }

    public DefaultWorkExecutorProvider withoutDefaultTaskFinalizer() {
        this.taskAdviceProfile.removeAfter(this.defaultTaskFinalizer);
        return this;
    }

    public ExecutorService workExecutor() {
        return RestrictedExecutorService.wrap((ExecutorService)new AdvisingExecutorService(this.workExecutorImplementation.get(), (AroundAdvice)this.taskAdviceProfile.advice()));
    }

    public AroundAdvice taskAdvice() {
        return this.taskAdviceProfile.advice();
    }

    public void defaultFinalizeTask() {
        MDC.clear();
    }

    public TaskAdviceFeature.Profile taskAdviceProfile() {
        return this.taskAdviceProfile;
    }

    @ExtensionPoint
    protected static class MyTaskAdviceProfile
    extends TaskAdviceFeature.Profile {
        protected MyTaskAdviceProfile() {
        }

        protected CompositeAroundAdvice advice() {
            return super.advice();
        }
    }
}

