/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.codec;

import ch.raffael.meldioc.library.codec.ContentType;
import ch.raffael.meldioc.library.codec.ContentTypes;
import ch.raffael.meldioc.library.codec.ObjectCodec;
import ch.raffael.meldioc.library.codec.ObjectCodecFactory;
import ch.raffael.meldioc.library.codec.ObjectDecoder;
import ch.raffael.meldioc.library.codec.ObjectEncoder;
import ch.raffael.meldioc.logging.Logging;
import ch.raffael.meldioc.util.Classes;
import ch.raffael.meldioc.util.IOStreams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.stream.JsonReader;
import io.vavr.API;
import io.vavr.Tuple2;
import io.vavr.control.Option;
import io.vavr.gson.VavrGson;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class GsonObjectCodec<T>
implements ObjectCodec<T> {
    private static final Logger LOG = Logging.logger();
    public static final int MIN_BUFFER_SIZE = 2;
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final ContentType CONTENT_TYPE = ContentTypes.JSON;
    public static final Option.Some<ContentType> SOME_CONTENT_TYPE = API.Some((Object)CONTENT_TYPE);
    private static final int PROBE_SIZE = 2;
    private final Gson gson;
    private final Class<T> type;
    private final int bufferSize;
    private final Option<Charset> charset;

    public GsonObjectCodec(Gson gson, Class<T> type) {
        this(gson, type, 8192, (Option<Charset>)API.None());
    }

    public GsonObjectCodec(Gson gson, Class<T> type, int bufferSize) {
        this(gson, type, bufferSize, (Option<Charset>)API.None());
    }

    public GsonObjectCodec(Gson gson, Class<T> type, Charset charset) {
        this(gson, type, 8192, (Option<Charset>)API.Some((Object)charset));
    }

    public GsonObjectCodec(Gson gson, Class<T> type, int bufferSize, Charset charset) {
        this(gson, type, bufferSize, (Option<Charset>)API.Some((Object)charset));
    }

    public GsonObjectCodec(Gson gson, Class<T> type, int bufferSize, Option<Charset> charset) {
        if (bufferSize < 2) {
            throw new IllegalArgumentException("Buffer size " + bufferSize + " too small, need at least 2");
        }
        this.gson = gson;
        this.type = type;
        this.bufferSize = bufferSize;
        this.charset = charset;
    }

    @Override
    public T decode(InputStream stream) throws IOException {
        Tuple2 scs = IOStreams.probe((InputStream)stream, this.charset, (int)this.bufferSize, (int)2, (head, __) -> ContentTypes.detectUnicodeCharset(head));
        return (T)this.gson.fromJson(new JsonReader((Reader)new InputStreamReader((InputStream)scs._2, (Charset)((Option)scs._1).getOrElse((Object)DEFAULT_CHARSET))), this.type);
    }

    @Override
    public T decode(byte[] data) {
        return (T)this.gson.fromJson(new JsonReader((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(data), (Charset)this.charset.getOrElse((Object)ContentTypes.detectUnicodeCharset(data)))), this.type);
    }

    @Override
    public ContentType encode(T value, OutputStream target) throws IOException {
        Charset charset = (Charset)this.charset.getOrElse((Object)DEFAULT_CHARSET);
        OutputStreamWriter out = new OutputStreamWriter(target, charset);
        this.gson.toJson(value, (Appendable)out);
        out.flush();
        return this.actualContentType(charset);
    }

    @Override
    public Tuple2<byte[], ContentType> encode(T value) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ContentType ct = this.encode(value, out);
        return API.Tuple((Object)out.toByteArray(), (Object)ct);
    }

    private ContentType actualContentType(Charset charset) {
        ContentType ct = ContentTypes.JSON;
        if (!ContentTypes.isImpliedUnicodeCharset(charset)) {
            ct = ct.addCharsetAttribute(charset);
        }
        return ct;
    }

    public static GsonBuilder standardGsonBuilder() {
        return GsonObjectCodec.registerVavr(GsonObjectCodec.probeRegisterVavr(GsonObjectCodec.loadServiceLoaderTypeAdapters(new GsonBuilder())));
    }

    public static GsonBuilder loadServiceLoaderTypeAdapters(GsonBuilder builder) {
        return GsonObjectCodec.loadServiceLoaderTypeAdapters(GsonObjectCodec.class, builder);
    }

    public static GsonBuilder loadServiceLoaderTypeAdapters(Class<?> refClass, GsonBuilder builder) {
        ServiceLoader.load(TypeAdapterFactory.class, Classes.classLoader(refClass)).stream().map(ServiceLoader.Provider::get).forEach(arg_0 -> ((GsonBuilder)builder).registerTypeAdapterFactory(arg_0));
        return builder;
    }

    public static GsonBuilder loadServiceLoaderTypeAdapters(ClassLoader classLoader, GsonBuilder builder) {
        ServiceLoader.load(TypeAdapterFactory.class, classLoader).stream().map(ServiceLoader.Provider::get).forEach(arg_0 -> ((GsonBuilder)builder).registerTypeAdapterFactory(arg_0));
        return builder;
    }

    public static GsonBuilder probeRegisterVavr(GsonBuilder builder) {
        try {
            Class.forName("io.vavr.gson.VavrGson");
            LOG.debug("Installing VavrGson");
            GsonObjectCodec.registerVavr(builder);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Not installing VavrGson: {}", (Object)e.toString());
        }
        return builder;
    }

    public static GsonBuilder registerVavr(GsonBuilder builder) {
        VavrGson.registerAll((GsonBuilder)builder);
        return builder;
    }

    public static class Factory
    implements ObjectCodecFactory {
        private final Gson gson;
        private final int bufferSize;
        private final Charset defaultCharset;

        public Factory(Gson gson, int bufferSize, Option<Charset> defaultCharset) {
            this.gson = gson;
            this.bufferSize = bufferSize;
            this.defaultCharset = (Charset)defaultCharset.getOrElse((Object)DEFAULT_CHARSET);
        }

        @Override
        public <T> Option<ObjectEncoder<T>> encoder(Class<T> type, Option<ContentType> contentType) {
            return API.Option(this.create(contentType, type));
        }

        @Override
        public <T> Option<ObjectDecoder<T>> decoder(Option<ContentType> contentType, Class<T> type) {
            return API.Option(this.create(contentType, type));
        }

        public <T> Option<ObjectCodec<T>> codec(Option<ContentType> contentType, Class<T> type) {
            return API.Option(this.create(contentType, type));
        }

        @Nullable
        private <T> GsonObjectCodec<T> create(Option<ContentType> contentType, Class<T> type) {
            return (GsonObjectCodec)contentType.orElse(SOME_CONTENT_TYPE).filter(ct -> ct.equalsTypeOnly(CONTENT_TYPE)).map(ct -> new GsonObjectCodec(this.gson, type, this.bufferSize, ct.charset(this.defaultCharset))).getOrNull();
        }

        @Override
        public boolean canEncode(Class<?> type) {
            return true;
        }

        @Override
        public boolean canEncodeAs(ContentType contentType) {
            return contentType.equalsTypeOnly(CONTENT_TYPE);
        }

        @Override
        public boolean canDecode(ContentType contentType) {
            return contentType.equalsTypeOnly(contentType);
        }

        @Override
        public boolean canDecodeAs(Class<?> type) {
            return true;
        }

        @Override
        public boolean isInvalidInput(Throwable exception) {
            return exception instanceof JsonParseException && !(exception instanceof JsonIOException);
        }
    }
}

