/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.codec;

import ch.raffael.meldioc.ExtensionPoint;
import ch.raffael.meldioc.Feature;
import ch.raffael.meldioc.Provision;
import ch.raffael.meldioc.library.codec.GsonObjectCodec;
import ch.raffael.meldioc.library.codec.ObjectCodecFeature;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.vavr.API;
import io.vavr.collection.Seq;
import io.vavr.control.Option;
import java.nio.charset.Charset;
import java.util.function.Consumer;

@Feature
public interface GsonObjectCodecFeature
extends ObjectCodecFeature {
    @Provision
    public Gson defaultGson();

    @ExtensionPoint.Acceptor
    public static final class Configuration {
        private static final Consumer<? super GsonBuilder> STANDARD = b -> {
            GsonObjectCodec.loadServiceLoaderTypeAdapters(b);
            GsonObjectCodec.registerVavr(b);
        };
        private Seq<Consumer<? super GsonBuilder>> configurators = API.Seq(STANDARD);
        private Option<Integer> bufferSize = API.None();
        private Option<Charset> defaultCharset = API.None();

        public Configuration removeStandardConfigurators() {
            this.configurators = this.configurators.remove(STANDARD);
            return this;
        }

        public Configuration configure(Consumer<? super GsonBuilder> configurator) {
            this.configurators = this.configurators.append(configurator);
            return this;
        }

        public Configuration bufferSize(int bufferSize) {
            if (this.bufferSize.isDefined()) {
                throw new IllegalStateException("Buffer size already set");
            }
            this.bufferSize = API.Some((Object)bufferSize);
            return this;
        }

        public Configuration defaultCharset(Charset defaultCharset) {
            if (this.defaultCharset.isDefined()) {
                throw new IllegalStateException("Default charset already set");
            }
            this.defaultCharset = API.Some((Object)defaultCharset);
            return this;
        }
    }

    @Feature
    public static abstract class Default
    implements GsonObjectCodecFeature {
        private final Configuration configuration = new Configuration();

        @Override
        @Provision(shared=true)
        public Gson defaultGson() {
            GsonBuilder builder = new GsonBuilder();
            this.configuration.configurators.forEach(c -> c.accept(builder));
            return builder.create();
        }

        @Override
        @Provision(shared=true)
        public GsonObjectCodec.Factory objectCodecFactory() {
            return new GsonObjectCodec.Factory(this.defaultGson(), (Integer)this.configuration.bufferSize.getOrElse((Object)8192), this.configuration.defaultCharset);
        }

        @ExtensionPoint
        protected Configuration gsonObjectCodecFeatureConfiguration() {
            return this.configuration;
        }
    }
}

