/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.codec;

import ch.raffael.meldioc.library.codec._ContentType;
import ch.raffael.meldioc.util.immutables.IllegalBuilderStateException;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.control.Option;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="_ContentType", generator="Immutables")
public final class ContentType
extends _ContentType {
    private final String type;
    private final String subtype;
    private final io.vavr.collection.Map<String, String> attributes;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long CHARSET_LAZY_INIT_BIT = 1L;
    private transient Option<Charset> charset;

    private ContentType(String type, String subtype, io.vavr.collection.Map<String, String> attributes) {
        this.type = Objects.requireNonNull(type, "type");
        this.subtype = Objects.requireNonNull(subtype, "subtype");
        this.attributes = attributes;
        this.initShim = null;
    }

    private ContentType(ContentType original, String type, String subtype, io.vavr.collection.Map<String, String> attributes) {
        this.type = type;
        this.subtype = subtype;
        this.attributes = attributes;
        this.initShim = null;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String subtype() {
        return this.subtype;
    }

    @Override
    public io.vavr.collection.Map<String, String> attributes() {
        return this.attributes;
    }

    public final ContentType withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ContentType(this, newValue, this.subtype, this.attributes);
    }

    public final ContentType withSubtype(String value) {
        String newValue = Objects.requireNonNull(value, "subtype");
        if (this.subtype.equals(newValue)) {
            return this;
        }
        return new ContentType(this, this.type, newValue, this.attributes);
    }

    public ContentType withAttributes(io.vavr.collection.Map<String, String> value) {
        io.vavr.collection.Map<String, String> newValue = value;
        if (this.attributes == newValue) {
            return this;
        }
        return new ContentType(this, this.type, this.subtype, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ContentType && this.equalTo((ContentType)another);
    }

    private boolean equalTo(ContentType another) {
        return this.type.equals(another.type) && this.subtype.equals(another.subtype) && this.attributes().equals(another.attributes());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.subtype.hashCode();
        h += (h << 5) + this.attributes().hashCode();
        return h;
    }

    public String toString() {
        return "ContentType{type=" + this.type + ", subtype=" + this.subtype + ", attributes=" + this.attributes().toString() + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Option<Charset> charset() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ContentType contentType = this;
            synchronized (contentType) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.charset = Objects.requireNonNull(super.charset(), "charset");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.charset;
    }

    public static ContentType of(String type, String subtype, io.vavr.collection.Map<String, String> attributes) {
        return new ContentType(type, subtype, attributes);
    }

    static ContentType copyOf(_ContentType instance) {
        if (instance instanceof ContentType) {
            return (ContentType)instance;
        }
        return ContentType.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_ContentType", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_SUBTYPE = 2L;
        private long initBits = 3L;
        private io.vavr.collection.Map<String, String> attributes_map = HashMap.empty();
        private String type;
        private String subtype;

        private Builder() {
        }

        public final Builder from(ContentType instance) {
            return this.from((_ContentType)instance);
        }

        final Builder from(_ContentType instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            this.subtype(instance.subtype());
            this.attributes(instance.attributes());
            return this;
        }

        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder subtype(String subtype) {
            this.subtype = Objects.requireNonNull(subtype, "subtype");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder putAttributes(String key, String value) {
            this.attributes_map = this.attributes_map.put((Object)key, (Object)value);
            return this;
        }

        public Builder putEntryAttributes(Tuple2<String, String> entry) {
            this.attributes_map = this.attributes_map.put(entry);
            return this;
        }

        public Builder attributes(io.vavr.collection.Map<String, String> elements) {
            this.attributes_map = elements;
            return this;
        }

        public Builder setJavaMapAttributes(Map<String, String> in_map) {
            this.attributes_map = HashMap.ofAll(in_map);
            return this;
        }

        public Builder setEntriesAttributes(Iterable<Tuple2<String, String>> entries) {
            this.attributes_map = HashMap.ofEntries(entries);
            return this;
        }

        public ContentType build() {
            this.checkRequiredAttributes();
            return new ContentType(null, this.type, this.subtype, this.attributes_build());
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean subtypeIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalBuilderStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.subtypeIsSet()) {
                attributes.add("subtype");
            }
            return "Cannot build ContentType, some of required attributes are not set " + attributes;
        }

        private io.vavr.collection.Map<String, String> attributes_build() {
            return this.attributes_map;
        }
    }

    @Generated(from="_ContentType", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build ContentType, attribute initializers form cycle " + attributes;
        }
    }
}

