/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.codec;

import ch.raffael.meldioc.library.codec.AbstractCharDataObjectCodec;
import ch.raffael.meldioc.library.codec.ContentType;
import ch.raffael.meldioc.library.codec.ContentTypes;
import ch.raffael.meldioc.library.codec.ObjectCodec;
import ch.raffael.meldioc.library.codec.ObjectCodecFactory;
import ch.raffael.meldioc.library.codec.ObjectDecoder;
import ch.raffael.meldioc.library.codec.ObjectEncoder;
import ch.raffael.meldioc.logging.Logging;
import ch.raffael.meldioc.util.Classes;
import com.fatboyindustrial.gsonjavatime.Converters;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.stream.JsonReader;
import io.vavr.control.Option;
import io.vavr.gson.VavrGson;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class GsonObjectCodec<T>
extends AbstractCharDataObjectCodec<T> {
    private static final Logger LOG = Logging.logger();
    private final Gson gson;
    private final Class<T> type;

    public GsonObjectCodec(Gson gson, Class<T> type) {
        this(gson, type, 8192, (Option<Charset>)Option.none());
    }

    public GsonObjectCodec(Gson gson, Class<T> type, int bufferSize) {
        this(gson, type, bufferSize, (Option<Charset>)Option.none());
    }

    public GsonObjectCodec(Gson gson, Class<T> type, Charset charset) {
        this(gson, type, 8192, (Option<Charset>)Option.some((Object)charset));
    }

    public GsonObjectCodec(Gson gson, Class<T> type, int bufferSize, Charset charset) {
        this(gson, type, bufferSize, (Option<Charset>)Option.some((Object)charset));
    }

    public GsonObjectCodec(Gson gson, Class<T> type, int bufferSize, Option<Charset> charset) {
        super(bufferSize, charset);
        this.gson = gson;
        this.type = type;
    }

    @Override
    protected T decode(Reader source) {
        return (T)this.gson.fromJson(new JsonReader(source), this.type);
    }

    @Override
    public boolean isInvalidInput(Throwable exception) {
        return GsonObjectCodec.isInvalidInput0(exception);
    }

    @Override
    protected void encode(Object value, Writer target) {
        this.gson.toJson(value, (Appendable)target);
    }

    @Override
    protected ContentType baseContentType() {
        return ContentTypes.JSON;
    }

    @Deprecated(forRemoval=true)
    public static GsonBuilder standardGsonBuilder() {
        return GsonObjectCodec.probeRegisterVavr(GsonObjectCodec.probeJavaTime(GsonObjectCodec.loadServiceLoaderTypeAdapters(new GsonBuilder())));
    }

    public static GsonBuilder loadServiceLoaderTypeAdapters(GsonBuilder builder) {
        return GsonObjectCodec.loadServiceLoaderTypeAdapters(GsonObjectCodec.class, builder);
    }

    public static GsonBuilder loadServiceLoaderTypeAdapters(Class<?> refClass, GsonBuilder builder) {
        ServiceLoader.load(TypeAdapterFactory.class, Classes.classLoader(refClass)).stream().map(ServiceLoader.Provider::get).forEach(arg_0 -> ((GsonBuilder)builder).registerTypeAdapterFactory(arg_0));
        return builder;
    }

    public static GsonBuilder loadServiceLoaderTypeAdapters(ClassLoader classLoader, GsonBuilder builder) {
        ServiceLoader.load(TypeAdapterFactory.class, classLoader).stream().map(ServiceLoader.Provider::get).forEach(arg_0 -> ((GsonBuilder)builder).registerTypeAdapterFactory(arg_0));
        return builder;
    }

    private static boolean isInvalidInput0(Throwable exception) {
        return exception instanceof JsonParseException && !(exception instanceof JsonIOException);
    }

    @Deprecated(forRemoval=true)
    public static GsonBuilder probeRegisterVavr(GsonBuilder builder) {
        try {
            Class.forName("io.vavr.gson.VavrGson");
            LOG.debug("Installing VavrGson");
            VavrGson.registerAll((GsonBuilder)builder);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Not installing VavrGson: {}", (Object)e.toString());
        }
        return builder;
    }

    @Deprecated(forRemoval=true)
    public static GsonBuilder probeJavaTime(GsonBuilder builder) {
        try {
            Class.forName("com.fatboyindustrial.gsonjavatime.Converters");
            LOG.debug("Installing java.time converters");
            Converters.registerAll((GsonBuilder)builder);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Not installing VavrGson: {}", (Object)e.toString());
        }
        return builder;
    }

    @Deprecated(forRemoval=true)
    public static GsonBuilder registerVavr(GsonBuilder builder) {
        VavrGson.registerAll((GsonBuilder)builder);
        return builder;
    }

    public static class Factory
    implements ObjectCodecFactory {
        private final Gson gson;
        private final int bufferSize;
        private final Charset defaultCharset;

        public Factory(Gson gson, int bufferSize, Option<Charset> defaultCharset) {
            this.gson = gson;
            this.bufferSize = bufferSize;
            this.defaultCharset = (Charset)defaultCharset.getOrElse((Object)StandardCharsets.UTF_8);
        }

        @Override
        public <T> Option<ObjectEncoder<T>> encoder(Class<T> type, Option<ContentType> contentType) {
            return Option.of(this.create(contentType, type));
        }

        @Override
        public <T> Option<ObjectDecoder<T>> decoder(Option<ContentType> contentType, Class<T> type) {
            return Option.of(this.create(contentType, type));
        }

        public <T> Option<ObjectCodec<T>> codec(Option<ContentType> contentType, Class<T> type) {
            return Option.of(this.create(contentType, type));
        }

        @Nullable
        private <T> GsonObjectCodec<T> create(Option<ContentType> contentType, Class<T> type) {
            return (GsonObjectCodec)contentType.orElse(AbstractCharDataObjectCodec.SOME_CONTENT_TYPE).filter(ct -> ct.equalsTypeOnly(AbstractCharDataObjectCodec.CONTENT_TYPE)).map(ct -> new GsonObjectCodec(this.gson, type, this.bufferSize, ct.charset(this.defaultCharset))).getOrNull();
        }

        @Override
        public boolean canEncode(Class<?> type) {
            return true;
        }

        @Override
        public boolean canEncodeAs(ContentType contentType) {
            return contentType.equalsTypeOnly(AbstractCharDataObjectCodec.CONTENT_TYPE);
        }

        @Override
        public boolean canDecode(ContentType contentType) {
            return contentType.equalsTypeOnly(contentType);
        }

        @Override
        public boolean canDecodeAs(Class<?> type) {
            return true;
        }

        @Override
        @Deprecated(forRemoval=true)
        public boolean isInvalidInput(Throwable exception) {
            return GsonObjectCodec.isInvalidInput0(exception);
        }
    }
}

