/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.codec;

import ch.raffael.meldioc.ExtensionPoint;
import ch.raffael.meldioc.Feature;
import ch.raffael.meldioc.Provision;
import ch.raffael.meldioc.library.codec.AbstractCharDataObjectCodec;
import ch.raffael.meldioc.library.codec.GsonObjectCodec;
import ch.raffael.meldioc.library.codec.ObjectCodecFactory;
import ch.raffael.meldioc.library.codec.ObjectCodecFeature;
import com.fatboyindustrial.gsonjavatime.Converters;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.vavr.collection.List;
import io.vavr.gson.VavrGson;
import java.util.function.Consumer;

@Feature
public interface GsonObjectCodecFeature
extends ObjectCodecFeature {
    @Deprecated(forRemoval=true)
    default public Gson defaultGson() {
        return this.gson();
    }

    @Provision
    public Gson gson();

    @Provision
    public GsonObjectCodec.Factory gsonObjectCodecFactory();

    @Override
    @Provision
    default public ObjectCodecFactory objectCodecFactory() {
        return this.gsonObjectCodecFactory();
    }

    @ExtensionPoint.Acceptor
    public static final class Configuration
    extends AbstractCharDataObjectCodec.Configuration<Configuration, GsonBuilder, Standard> {
        public Configuration() {
            super(List.of((Object[])Standard.values()));
        }

        protected Standard[] allStandardConfigurators() {
            return Standard.values();
        }

        public static enum Standard implements Consumer<GsonBuilder>
        {
            SERVICE_LOADER{

                @Override
                public void accept(GsonBuilder b) {
                    GsonObjectCodec.loadServiceLoaderTypeAdapters(b);
                }
            }
            ,
            JAVA_TIME{

                @Override
                public void accept(GsonBuilder b) {
                    Converters.registerAll((GsonBuilder)b);
                }
            }
            ,
            VAVR{

                @Override
                public void accept(GsonBuilder b) {
                    VavrGson.registerAll((GsonBuilder)b);
                }
            };

        }
    }

    @Feature
    public static abstract class Default
    implements GsonObjectCodecFeature {
        private final Configuration configuration = new Configuration();

        @Override
        @Provision(singleton=true)
        public Gson gson() {
            GsonBuilder builder = new GsonBuilder();
            this.configuration.configurators().forEach(c -> c.accept(builder));
            return builder.create();
        }

        @Override
        @Provision(singleton=true)
        public GsonObjectCodec.Factory gsonObjectCodecFactory() {
            return new GsonObjectCodec.Factory(this.gson(), (Integer)this.configuration.bufferSize().getOrElse((Object)8192), this.configuration.defaultCharset());
        }

        @ExtensionPoint
        protected Configuration gsonObjectCodecFeatureConfiguration() {
            return this.configuration;
        }
    }
}

