/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.codec;

import ch.raffael.meldioc.library.codec.ContentType;
import ch.raffael.meldioc.library.codec.ContentTypes;
import ch.raffael.meldioc.library.codec.ObjectCodec;
import ch.raffael.meldioc.util.IOStreams;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.Seq;
import io.vavr.control.Option;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.function.Consumer;

public abstract class AbstractCharDataObjectCodec<T>
implements ObjectCodec<T> {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int MIN_BUFFER_SIZE = 2;
    public static final ContentType CONTENT_TYPE = ContentTypes.JSON;
    public static final Option<ContentType> SOME_CONTENT_TYPE = Option.some((Object)CONTENT_TYPE);
    private static final int PROBE_SIZE = 2;
    private final int bufferSize;
    private final Option<Charset> charset;

    protected AbstractCharDataObjectCodec() {
        this(8192, (Option<Charset>)Option.none());
    }

    protected AbstractCharDataObjectCodec(Option<Charset> charset) {
        this(8192, charset);
    }

    protected AbstractCharDataObjectCodec(int bufferSize) {
        this(bufferSize, (Option<Charset>)Option.none());
    }

    protected AbstractCharDataObjectCodec(int bufferSize, Option<Charset> charset) {
        if (bufferSize < 2) {
            throw new IllegalArgumentException("Buffer size " + bufferSize + " too small, need at least 2");
        }
        this.bufferSize = bufferSize;
        this.charset = charset;
    }

    @Override
    public T decode(InputStream stream) throws IOException {
        Tuple2 scs = IOStreams.probe((InputStream)stream, this.charset, (int)this.bufferSize, (int)2, (head, __) -> ContentTypes.detectUnicodeCharset(head));
        return this.decode(new InputStreamReader((InputStream)scs._2, (Charset)((Option)scs._1).getOrElse(this::defaultCharset)));
    }

    @Override
    public T decode(byte[] data) throws IOException {
        return this.decode(new InputStreamReader((InputStream)new ByteArrayInputStream(data), (Charset)this.charset.getOrElse((Object)ContentTypes.detectUnicodeCharset(data))));
    }

    @Override
    public ContentType encode(T value, OutputStream target) throws IOException {
        Charset charset = (Charset)this.charset.getOrElse(this::defaultCharset);
        OutputStreamWriter out = new OutputStreamWriter(target, charset);
        this.encode(value, out);
        out.flush();
        return this.actualContentType(charset);
    }

    @Override
    public Tuple2<byte[], ContentType> encode(T value) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ContentType ct = this.encode(value, out);
        return Tuple.of((Object)out.toByteArray(), (Object)ct);
    }

    protected abstract T decode(Reader var1) throws IOException;

    protected abstract void encode(T var1, Writer var2) throws IOException;

    protected Charset defaultCharset() {
        return StandardCharsets.UTF_8;
    }

    protected abstract ContentType baseContentType();

    private ContentType actualContentType(Charset charset) {
        ContentType ct = this.baseContentType();
        if (!ContentTypes.isImpliedUnicodeCharset(charset)) {
            ct = ct.addCharsetAttribute(charset);
        }
        return ct;
    }

    public static abstract class Configuration<SELF, T, S extends Consumer<? super T>> {
        private Seq<Consumer<? super T>> configurators;
        private Option<Integer> bufferSize = Option.none();
        private Option<Charset> defaultCharset = Option.none();

        public Configuration(Seq<Consumer<? super T>> configurators) {
            this.configurators = configurators;
        }

        @SafeVarargs
        public final SELF removeStandardConfigurators(S ... remove) {
            if (remove == null || remove.length == 0) {
                this.removeStandardConfigurators(this.allStandardConfigurators());
            } else {
                this.configurators = this.configurators.removeAll(Arrays.asList(remove));
            }
            return this.self();
        }

        protected abstract S[] allStandardConfigurators();

        public SELF configure(Consumer<? super T> configurator) {
            this.configurators = this.configurators.append(configurator);
            return this.self();
        }

        public SELF bufferSize(int bufferSize) {
            if (this.bufferSize.isDefined()) {
                throw new IllegalStateException("Buffer size already set");
            }
            this.bufferSize = Option.some((Object)bufferSize);
            return this.self();
        }

        public SELF defaultCharset(Charset defaultCharset) {
            if (this.defaultCharset.isDefined()) {
                throw new IllegalStateException("Default charset already set");
            }
            this.defaultCharset = Option.some((Object)defaultCharset);
            return this.self();
        }

        protected Seq<Consumer<? super T>> configurators() {
            return this.configurators;
        }

        protected Option<Integer> bufferSize() {
            return this.bufferSize;
        }

        protected Option<Charset> defaultCharset() {
            return this.defaultCharset;
        }

        protected SELF self() {
            return (SELF)this;
        }
    }
}

