/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.codec;

import ch.raffael.meldioc.library.codec.ContentType;
import ch.raffael.meldioc.library.codec.ContentTypes;
import ch.raffael.meldioc.util.immutables.Immutable;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.immutables.value.Value;

@Immutable.Public
abstract class _ContentType {
    _ContentType() {
    }

    public static ContentType of(String type, String subtype) {
        return ContentType.of(type, subtype, (Map<String, String>)HashMap.empty());
    }

    @Value.Parameter
    public abstract String type();

    @Value.Parameter
    public abstract String subtype();

    @Value.Parameter
    public abstract Map<String, String> attributes();

    public ContentType withoutAttributes() {
        return ((ContentType)this).withAttributes((Map<String, String>)HashMap.empty());
    }

    public ContentType addCharsetAttribute(Charset charset) {
        return ((ContentType)this).withAttributes((Map<String, String>)this.attributes().put((Object)"charset", (Object)charset.name()));
    }

    public ContentType withDefaultCharset(Charset charset) {
        ContentType self = (ContentType)this;
        return this.attributes().containsKey((Object)"charset") ? self : self.addCharsetAttribute(charset);
    }

    @Value.Lazy
    public Option<Charset> charset() {
        return this.attributes().get((Object)"charset").map(Charset::forName).orElse(() -> this.equalsTypeOnly(ContentTypes.XML) || this.equalsTypeOnly(ContentTypes.JSON) ? Option.some((Object)StandardCharsets.UTF_8) : Option.none());
    }

    public Charset charset(Charset fallback) {
        return (Charset)this.charset().getOrElse((Object)fallback);
    }

    public boolean equalsTypeOnly(ContentType that) {
        return this.type().equals(that.type()) && this.subtype().equals(that.subtype());
    }

    public String render() {
        return this.render(new StringBuilder()).toString();
    }

    public StringBuilder render(StringBuilder buf) {
        ContentType self = (ContentType)this;
        Map attr = this.attributes();
        if (ContentTypes.isUnicodeType(self) && ((Boolean)this.charset().map(ContentTypes::isImpliedUnicodeCharset).getOrElse((Object)false)).booleanValue()) {
            attr = attr.remove((Object)"charset");
        }
        buf.append(this.type()).append('/').append(this.subtype());
        if (!attr.isEmpty()) {
            buf.append(';');
            this.attributes().forEach((k, v) -> {
                String quote = "";
                for (int i = 0; i < v.length(); ++i) {
                    if (ContentTypes.Parser.isTokenChar(v.charAt(i))) continue;
                    quote = "\"";
                    break;
                }
                buf.append(' ').append((String)k).append('=').append(quote).append((String)v).append(quote);
            });
        }
        return buf;
    }
}

