/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.codec;

import ch.raffael.meldioc.library.codec.ContentType_Immutable;
import ch.raffael.meldioc.library.codec.ContentType_With;
import ch.raffael.meldioc.library.codec.ContentTypes;
import ch.raffael.meldioc.util.immutables.Immutable;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.immutables.value.Value;

@Immutable.Pure
public abstract class ContentType
implements ContentType_With {
    ContentType() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ContentType of(String type, String subtype) {
        return ContentType.of(type, subtype, (Map<String, String>)HashMap.empty());
    }

    public static ContentType of(String type, String subtype, Map<String, String> attributes) {
        return ContentType_Immutable.of(type, subtype, attributes);
    }

    public static ContentType of(String contentType) {
        return (ContentType)ContentTypes.parseContentType(contentType).getOrElseThrow(() -> new IllegalArgumentException("Cannot parse content type: " + contentType));
    }

    @Value.Parameter
    public abstract String type();

    @Value.Parameter
    public abstract String subtype();

    @Value.Parameter
    public abstract Map<String, String> attributes();

    public ContentType withoutAttributes() {
        return this.withAttributes((Map<String, String>)HashMap.empty());
    }

    public ContentType addCharsetAttribute(Charset charset) {
        return this.withAttributes((Map<String, String>)this.attributes().put((Object)"charset", (Object)charset.name()));
    }

    public ContentType withDefaultCharset(Charset charset) {
        return this.attributes().containsKey((Object)"charset") ? this : this.addCharsetAttribute(charset);
    }

    @Value.Lazy
    public Option<Charset> charset() {
        return this.attributes().get((Object)"charset").map(Charset::forName).orElse(() -> this.equalsTypeOnly(ContentTypes.XML) || this.equalsTypeOnly(ContentTypes.JSON) ? Option.some((Object)StandardCharsets.UTF_8) : Option.none());
    }

    public Charset charset(Charset fallback) {
        return (Charset)this.charset().getOrElse((Object)fallback);
    }

    public boolean equalsTypeOnly(ContentType that) {
        return this.type().equals(that.type()) && this.subtype().equals(that.subtype());
    }

    public String render() {
        return this.render(new StringBuilder()).toString();
    }

    public StringBuilder render(StringBuilder buf) {
        Map attr = this.attributes();
        if (ContentTypes.isUnicodeType(this) && ((Boolean)this.charset().map(ContentTypes::isImpliedUnicodeCharset).getOrElse((Object)false)).booleanValue()) {
            attr = attr.remove((Object)"charset");
        }
        buf.append(this.type()).append('/').append(this.subtype());
        if (!attr.isEmpty()) {
            buf.append(';');
            this.attributes().forEach((k, v) -> {
                String quote = "";
                for (int i = 0; i < v.length(); ++i) {
                    if (ContentTypes.Parser.isTokenChar(v.charAt(i))) continue;
                    quote = "\"";
                    break;
                }
                buf.append(' ').append((String)k).append('=').append(quote).append((String)v).append(quote);
            });
        }
        return buf;
    }

    public static ContentType xml() {
        return ContentTypes.XML;
    }

    public static ContentType json() {
        return ContentTypes.JSON;
    }

    public static ContentType html() {
        return ContentTypes.HTML;
    }

    public static ContentType xhtml() {
        return ContentTypes.XHTML;
    }

    public static ContentType javascript() {
        return ContentTypes.JAVASCRIPT;
    }

    public static ContentType css() {
        return ContentTypes.CSS;
    }

    public static ContentType plainText() {
        return ContentTypes.PLAIN_TEXT;
    }

    public static ContentType octetStream() {
        return ContentTypes.OCTET_STREAM;
    }

    public static ContentType png() {
        return ContentTypes.PNG;
    }

    public static ContentType jpeg() {
        return ContentTypes.JPEG;
    }

    public static ContentType tentativeYaml() {
        return ContentTypes.TENTATIVE_YAML;
    }

    public static final class Builder
    extends ContentType_Immutable.Builder {
        Builder() {
        }
    }
}

