/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.codec;

import ch.raffael.meldioc.library.codec.ContentType;
import io.vavr.collection.HashSet;
import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.control.Option;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.Nullable;

public final class ContentTypes {
    public static final String CHARSET_ATTR = "charset";
    public static final String Q_ATTR = "q";
    public static final ContentType XML = ContentType.of("application", "xml");
    public static final ContentType JSON = ContentType.of("application", "json");
    public static final ContentType HTML = ContentType.of("text", "html");
    public static final ContentType XHTML = ContentType.of("application", "xhtml+xml");
    public static final ContentType JAVASCRIPT = ContentType.of("application", "javascript");
    public static final ContentType CSS = ContentType.of("text", "css");
    public static final ContentType PLAIN_TEXT = ContentType.of("text", "plain");
    public static final ContentType OCTET_STREAM = ContentType.of("application", "octet-stream");
    public static final ContentType JPEG = ContentType.of("image", "jpeg");
    public static final ContentType PNG = ContentType.of("image", "png");
    public static final ContentType TENTATIVE_YAML = ContentType.of("application", "x-yaml");
    public static final Set<Charset> IMPLIED_UNICODE_CHARSETS = HashSet.of((Object[])new Charset[]{StandardCharsets.UTF_8, StandardCharsets.UTF_16, StandardCharsets.UTF_16BE, StandardCharsets.UTF_16LE});

    private ContentTypes() {
    }

    public static boolean isUnicodeType(ContentType contentType) {
        return contentType.equalsTypeOnly(XML) || contentType.equalsTypeOnly(JSON) || contentType.equalsTypeOnly(XHTML);
    }

    public static boolean isXml(ContentType contentType) {
        return contentType.equalsTypeOnly(XML);
    }

    public static boolean isJson(ContentType contentType) {
        return contentType.equalsTypeOnly(JSON);
    }

    public static Charset detectUnicodeCharset(byte[] bytes) {
        if (bytes.length >= 2) {
            return ContentTypes.detectUnicodeCharset(bytes[0], bytes[1]);
        }
        return StandardCharsets.UTF_8;
    }

    public static Charset detectUnicodeCharset(int b0, int b1) {
        if (b0 < 0 || b1 < 0) {
            return StandardCharsets.UTF_8;
        }
        if (b0 == 0 && b1 != 0) {
            return StandardCharsets.UTF_16BE;
        }
        if (b0 != 0 && b1 == 0) {
            return StandardCharsets.UTF_16LE;
        }
        return StandardCharsets.UTF_8;
    }

    public static boolean isImpliedUnicodeCharset(Charset charset) {
        return IMPLIED_UNICODE_CHARSETS.contains((Object)charset);
    }

    public static Option<ContentType> parseContentType(String contentTypeString) {
        return new Parser(contentTypeString).toContentType();
    }

    public static Seq<ContentType> parseContentTypeList(String contentTypeString) {
        int pos;
        List split = List.empty();
        boolean inQuote = false;
        int prev = 0;
        for (pos = 0; pos < contentTypeString.length(); ++pos) {
            char c = contentTypeString.charAt(pos);
            if (c == '\"') {
                inQuote = !inQuote;
                continue;
            }
            if (inQuote || c != ',') continue;
            split = split.append((Object)contentTypeString.substring(prev, pos));
            prev = pos + 1;
        }
        if (prev < pos) {
            split = split.append((Object)contentTypeString.substring(prev, pos));
        }
        return split.flatMap(ContentTypes::parseContentType);
    }

    public static Seq<ContentType> parseContentTypeListQ(String contentTypeString) {
        return ContentTypes.parseContentTypeList(contentTypeString).sortBy(ct -> (Double)ct.attributes().get((Object)Q_ATTR).map(q -> {
            try {
                return Double.parseDouble(q);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }).getOrElse((Object)1.0)).reverse();
    }

    static final class Parser {
        private static final String TSPECIAL = "()<>@,;:\\\"/[]?=";
        private final String source;
        private int position = 0;
        private final StringBuilder buf;
        @Nullable
        private String type = null;
        @Nullable
        private String subtype = null;
        private Map<String, String> attributes = LinkedHashMap.empty();

        private Parser(String source) {
            this.source = source;
            this.buf = new StringBuilder(source.length());
        }

        static boolean isTokenChar(char c) {
            return c >= '!' && c <= '\u007f' && TSPECIAL.indexOf(c) < 0;
        }

        private Option<ContentType> toContentType() {
            this.type = null;
            this.subtype = null;
            this.attributes = LinkedHashMap.empty();
            this.parse();
            if (this.type != null && this.subtype != null) {
                return Option.some((Object)ContentType.of(this.type, this.subtype, this.attributes));
            }
            return Option.none();
        }

        private void parse() {
            this.skipSpace();
            if (this.end()) {
                return;
            }
            this.type = this.token();
            if (this.type.isEmpty() || !this.skipSpace()) {
                return;
            }
            if (this.c() != '/' || this.end()) {
                return;
            }
            this.next();
            if (!this.skipSpace()) {
                return;
            }
            this.subtype = this.token();
            if (this.subtype.isEmpty() || !this.skipSpace()) {
                return;
            }
            if (this.c() != ';') {
                return;
            }
            this.next();
            while (this.skipSpace()) {
                String value;
                String name = this.token();
                if (name.isEmpty()) {
                    return;
                }
                if (!this.skipSpace()) {
                    return;
                }
                if (this.c() != '=') {
                    return;
                }
                if (!this.next()) {
                    return;
                }
                if (this.c() == '\"' ? (value = this.quoted()) == null : (value = this.token()).isEmpty()) {
                    return;
                }
                this.attributes = this.attributes.put((Object)name, (Object)value);
            }
        }

        private String token() {
            this.buf.setLength(0);
            while (!this.end() && this.isTokenChar()) {
                this.buf.append(this.c());
                this.next();
            }
            return this.buf.toString();
        }

        @Nullable
        private String quoted() {
            this.buf.setLength(0);
            this.next();
            while (this.more() && this.c() != '\"') {
                this.buf.append(this.c());
                this.next();
            }
            return this.c() == '\"' ? this.buf.toString() : null;
        }

        private char c() {
            return this.source.charAt(this.position);
        }

        private boolean next() {
            ++this.position;
            return !this.end();
        }

        private boolean more() {
            return !this.end();
        }

        private boolean end() {
            return this.position >= this.source.length();
        }

        private boolean skipSpace() {
            while (!this.end()) {
                if (!Character.isWhitespace(this.c())) {
                    return true;
                }
                this.next();
            }
            return false;
        }

        private boolean isTokenChar() {
            return Parser.isTokenChar(this.c());
        }
    }
}

