/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.handler;

import ch.raffael.meldioc.library.http.server.undertow.codec.HttpDecoder;
import ch.raffael.meldioc.library.http.server.undertow.codec.HttpEncoder;
import ch.raffael.meldioc.library.http.server.undertow.handler.DispatchMode;
import ch.raffael.meldioc.library.http.server.undertow.handler.ErrorMessageHandler;
import ch.raffael.meldioc.library.http.server.undertow.util.HttpStatusException;
import ch.raffael.meldioc.util.Exceptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.function.Function;

public class ActionHandler<C, B, R>
implements HttpHandler {
    private final HttpDecoder<? super C, ? extends B> decoder;
    private final HttpEncoder<? super C, ? super R> encoder;
    private final Function<? super HttpServerExchange, ? extends C> context;
    private final Invoker<C, B, R> invoker;
    private final DispatchMode dispatch;

    public ActionHandler(HttpDecoder<? super C, ? extends B> decoder, HttpEncoder<? super C, ? super R> encoder, Function<? super HttpServerExchange, ? extends C> context, Invoker<C, B, R> invoker) {
        this(decoder, encoder, context, invoker, DispatchMode.DISPATCH);
    }

    public ActionHandler(HttpDecoder<? super C, ? extends B> decoder, HttpEncoder<? super C, ? super R> encoder, Function<? super HttpServerExchange, ? extends C> context, Invoker<C, B, R> invoker, boolean dispatch) {
        this(decoder, encoder, context, invoker, dispatch ? DispatchMode.DISPATCH : DispatchMode.NON_BLOCKING);
    }

    public ActionHandler(HttpDecoder<? super C, ? extends B> decoder, HttpEncoder<? super C, ? super R> encoder, Function<? super HttpServerExchange, ? extends C> context, Invoker<C, B, R> invoker, DispatchMode dispatch) {
        this.decoder = decoder;
        this.encoder = encoder;
        this.context = context;
        this.invoker = invoker;
        this.dispatch = dispatch;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.dispatch.dispatch(exchange, this)) {
            return;
        }
        C ctx = this.context.apply((HttpServerExchange)exchange);
        this.decoder.decode(exchange, ctx, (ex, body) -> {
            try {
                R response = this.invoker.invoke(ex, ctx, body);
                this.encoder.encode(ex, ctx, response);
            }
            catch (HttpStatusException e) {
                throw e;
            }
            catch (Throwable e) {
                Exceptions.rethrowIfFatal((Throwable)e);
                ErrorMessageHandler.addMessage(exchange, e);
                throw e;
            }
        });
    }

    public static interface Invoker<C, B, R> {
        public R invoke(HttpServerExchange var1, C var2, B var3) throws Exception;
    }
}

