/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.handler;

import ch.raffael.meldioc.library.codec.ContentType;
import ch.raffael.meldioc.library.codec.ContentTypes;
import ch.raffael.meldioc.util.Exceptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.AttachmentList;
import io.undertow.util.Headers;
import io.undertow.util.StatusCodes;
import io.vavr.API;
import io.vavr.Function3;
import io.vavr.Tuple2;
import io.vavr.Value;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.collection.Stream;
import io.vavr.control.Option;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class ErrorMessageHandler
implements HttpHandler {
    private static final AttachmentKey<AttachmentList<Object>> ERROR_MESSAGES_KEY = AttachmentKey.createList(Object.class);
    private static final AttachmentKey<AttachmentList<MessageRenderer>> MESSAGE_RENDERER_KEY = AttachmentKey.createList(MessageRenderer.class);
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final String NON_ESCAPED_CONTROLS = "\n\r \t";
    private final HttpHandler next;
    private final Tuple2<ContentType, Function3<Integer, String, Seq<String>, String>> standardRenderer = API.Tuple((Object)ContentTypes.PLAIN_TEXT.withDefaultCharset(CHARSET), this::renderText);
    private final Map<ContentType, Function3<Integer, String, Seq<String>, String>> renderers = API.Map((Object)ContentTypes.JSON, this::renderJson, (Object)ContentTypes.XML, this::renderXml, (Object)ContentTypes.PLAIN_TEXT, this::renderText);

    public ErrorMessageHandler(HttpHandler next) {
        this.next = next;
    }

    public static void addMessage(HttpServerExchange exchange, Object message) {
        exchange.addToAttachmentList(ERROR_MESSAGES_KEY, message);
    }

    public static void addMessageRenderer(HttpServerExchange exchange, MessageRenderer renderer) {
        exchange.addToAttachmentList(MESSAGE_RENDERER_KEY, (Object)renderer);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.addToAttachmentList(MESSAGE_RENDERER_KEY, (Object)this.exceptionRenderer());
        exchange.addDefaultResponseListener(this::handleDefaultResponse);
        this.next.handleRequest(exchange);
    }

    protected MessageRenderer exceptionRenderer() {
        return ExceptionRenderer.DEFAULT_INSTANCE;
    }

    protected boolean handleDefaultResponse(HttpServerExchange exchange) {
        if (!exchange.isResponseChannelAvailable()) {
            return false;
        }
        if (this.isError(exchange.getStatusCode())) {
            String reason = StatusCodes.getReason((int)exchange.getStatusCode());
            Stream messages = Stream.ofAll((Iterable)exchange.getAttachmentList(ERROR_MESSAGES_KEY)).map(m -> this.renderMessage(exchange, m));
            Option step = API.Option((Object)exchange.getRequestHeaders().getFirst(Headers.ACCEPT)).filter(s -> !s.isBlank()).map(ContentTypes::parseContentTypeListQ);
            Tuple2 errorPage = ((Tuple2)step.flatMap(cts -> (Option)cts.foldLeft((Object)API.None(), (cur, ct) -> cur.orElse(() -> this.renderers.get((Object)ct.withoutAttributes()).map(r -> API.Tuple((Object)ct, (Object)r))))).map(t -> t.map1(ct -> ct.withDefaultCharset(CHARSET))).getOrElse(this.standardRenderer)).map2(r -> (String)r.apply((Object)exchange.getStatusCode(), (Object)reason, (Object)messages)).map1(ct -> ContentTypes.isUnicodeType((ContentType)ct) ? ct.withDefaultCharset(StandardCharsets.UTF_8) : ct);
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, ((ContentType)errorPage._1).render());
            exchange.getResponseSender().send((String)errorPage._2);
            return true;
        }
        return false;
    }

    protected boolean isError(int statusCode) {
        return statusCode >= 400;
    }

    protected String renderMessage(HttpServerExchange exchange, Object message) {
        return exchange.getAttachmentList(MESSAGE_RENDERER_KEY).stream().map(r -> r.render(exchange, message)).flatMap(Value::toJavaStream).findFirst().orElseGet(() -> String.valueOf(message));
    }

    protected String renderJson(int code, String reason, Seq<String> messages) {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        ErrorMessageHandler.appendJsonQuoted(buf, "statusCode").append(':').append(code).append(",\n");
        ErrorMessageHandler.appendJsonQuoted(buf, "reason").append(':');
        ErrorMessageHandler.appendJsonQuoted(buf, reason).append(",\n");
        ErrorMessageHandler.appendJsonQuoted(buf, "messages").append(": [");
        boolean first = true;
        for (String m : messages) {
            buf.append("\n ");
            ErrorMessageHandler.appendJsonQuoted(buf, m);
            if (first) {
                first = false;
                continue;
            }
            buf.append(',');
        }
        buf.append("]}");
        return buf.toString();
    }

    protected String renderXml(int code, String reason, Seq<String> messages) {
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buf.append("<error>\n");
        buf.append(" <statusCode>").append(code).append("</statusCode>\n");
        ErrorMessageHandler.appendXmlEscaped(buf.append(" <reason>"), reason).append("</reason>\n");
        if (messages.isEmpty()) {
            buf.append(" <messages/>\n");
        } else {
            buf.append(" <messages>\n");
            for (String m : messages) {
                ErrorMessageHandler.appendXmlEscaped(buf.append("  <message>"), m).append("</message>\n");
            }
            buf.append(" </messages>");
        }
        buf.append("\n</error>\n");
        return buf.toString();
    }

    protected String renderText(int code, String reason, Seq<String> messages) {
        StringBuilder buf = new StringBuilder();
        buf.append(code).append(' ').append(reason).append('\n');
        messages.forEach(m -> buf.append("- ").append((String)m).append('\n'));
        return buf.toString();
    }

    protected static StringBuilder appendJsonQuoted(StringBuilder buf, String str) {
        buf.append('\"');
        block9: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\b': {
                    buf.append("\\b");
                    continue block9;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block9;
                }
                case '\f': {
                    buf.append("\\f");
                    continue block9;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block9;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block9;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block9;
                }
                default: {
                    if (Character.isISOControl(c)) {
                        ErrorMessageHandler.unicodeHex4(buf.append("\\u"), c);
                        continue block9;
                    }
                    buf.append(c);
                }
            }
        }
        buf.append('\"');
        return buf;
    }

    protected static StringBuilder appendXmlEscaped(StringBuilder buf, String str) {
        block5: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '<': {
                    buf.append("&lt;");
                    continue block5;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block5;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block5;
                }
                default: {
                    if (Character.isISOControl(c) && NON_ESCAPED_CONTROLS.indexOf(c) < 0) {
                        ErrorMessageHandler.unicodeHex4(buf.append("&#x"), c).append(';');
                        continue block5;
                    }
                    buf.append(c);
                }
            }
        }
        return buf;
    }

    protected static StringBuilder unicodeHex4(StringBuilder buf, char c) {
        String s = Integer.toString(c, 16);
        buf.append("0".repeat(Math.max(0, 4 - s.length())));
        return buf.append(s);
    }

    public static class ExceptionRenderer
    implements MessageRenderer {
        private static final ExceptionRenderer DEFAULT_INSTANCE = new ExceptionRenderer();
        private static final AttachmentKey<Boolean> SUPPRESS_STACK_TRACES = AttachmentKey.create(Boolean.class);

        public static ExceptionRenderer defaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static HttpServerExchange setSuppressStackTraces(HttpServerExchange exchange, boolean suppress) {
            exchange.putAttachment(SUPPRESS_STACK_TRACES, (Object)suppress);
            return exchange;
        }

        public static HttpServerExchange setSuppressStackTraces(HttpServerExchange exchange, Predicate<? super HttpServerExchange> suppress) {
            exchange.putAttachment(SUPPRESS_STACK_TRACES, (Object)suppress.test((HttpServerExchange)exchange));
            return exchange;
        }

        public static HttpHandler suppressStackTracesHandler(HttpHandler next) {
            return e -> next.handleRequest(ExceptionRenderer.setSuppressStackTraces(e, true));
        }

        public static HttpHandler suppressStackTracesHandler(HttpHandler next, Predicate<? super HttpServerExchange> suppress) {
            return e -> next.handleRequest(ExceptionRenderer.setSuppressStackTraces(e, suppress.test(e)));
        }

        public static HttpHandler suppressStackTracesHandler(HttpHandler next, Supplier<Boolean> suppress) {
            return e -> next.handleRequest(ExceptionRenderer.setSuppressStackTraces(e, Objects.requireNonNullElse((Boolean)suppress.get(), false)));
        }

        @Override
        public Option<String> render(HttpServerExchange exchange, Object message) {
            return !(message instanceof Throwable) ? API.None() : API.Some((Object)Exceptions.toString((Throwable)((Throwable)message), (boolean)((Boolean)API.Option((Object)((Boolean)exchange.getAttachment(SUPPRESS_STACK_TRACES))).map(s -> s == false).getOrElse((Object)true))));
        }
    }

    @FunctionalInterface
    public static interface MessageRenderer {
        public Option<String> render(HttpServerExchange var1, Object var2);

        public static <T> MessageRenderer forType(Class<T> type, Function<? super T, String> fun) {
            return MessageRenderer.forType(type, (? super HttpServerExchange __, ? super T m) -> (String)fun.apply(m));
        }

        public static <T> MessageRenderer forType(Class<T> type, BiFunction<? super HttpServerExchange, ? super T, String> fun) {
            return (e, m) -> type.isInstance(m) ? API.None() : API.Some((Object)((String)fun.apply((HttpServerExchange)e, (Object)type.cast(m))));
        }

        public static MessageRenderer stringValue() {
            return (__, m) -> API.Some((Object)String.valueOf(m));
        }

        public static MessageRenderer stringValue(Class<?> type) {
            return MessageRenderer.forType(type, String::valueOf);
        }
    }
}

