/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.handler;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.vavr.API;
import io.vavr.Tuple2;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.control.Option;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;

public final class PathSegmentHandler
implements HttpHandler {
    private static final Pattern DECODE_SLASH_RE = Pattern.compile("%2[fF]");
    private final Option<HttpHandler> hereHandler;
    private final Map<String, HttpHandler> exactSegments;
    private final Option<Tuple2<Seq<? extends BiConsumer<? super HttpServerExchange, ? super String>>, HttpHandler>> captureHandler;
    private final HttpHandler defaultHandler;

    private PathSegmentHandler(Option<HttpHandler> hereHandler, Map<String, HttpHandler> exactSegments, Option<Tuple2<Seq<? extends BiConsumer<? super HttpServerExchange, ? super String>>, HttpHandler>> captureHandler, HttpHandler defaultHandler) {
        this.hereHandler = hereHandler;
        this.exactSegments = exactSegments;
        this.captureHandler = captureHandler;
        this.defaultHandler = defaultHandler;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String segment = exchange.getRelativePath();
        if (segment.isEmpty() || segment.equals("/")) {
            if (!segment.isEmpty()) {
                exchange.setResolvedPath(exchange.getResolvedPath() + segment);
                exchange.setRelativePath("");
            }
            ((HttpHandler)this.hereHandler.getOrElse(() -> this.defaultHandler)).handleRequest(exchange);
        } else {
            Option exact;
            if (!exchange.getRelativePath().startsWith("/")) {
                throw new IllegalStateException("Relative path must start with '/'");
            }
            int slash = (segment = segment.substring(1)).indexOf(47);
            if (slash >= 0) {
                segment = segment.substring(0, slash);
            }
            if ((exact = this.exactSegments.get((Object)segment)).isDefined()) {
                this.updateMatch(exchange, segment);
                ((HttpHandler)exact.get()).handleRequest(exchange);
            } else {
                Option<Tuple2<Seq<? extends BiConsumer<? super HttpServerExchange, ? super String>>, HttpHandler>> cap = this.captureHandler;
                if (cap.isDefined()) {
                    String decodedSegment = this.decodeSegment(segment);
                    for (BiConsumer c : (Seq)((Tuple2)cap.get())._1) {
                        c.accept(exchange, decodedSegment);
                    }
                    this.updateMatch(exchange, segment);
                    ((HttpHandler)((Tuple2)cap.get())._2).handleRequest(exchange);
                } else {
                    this.defaultHandler.handleRequest(exchange);
                }
            }
        }
    }

    private String decodeSegment(String segment) {
        return segment.indexOf(37) >= 0 ? DECODE_SLASH_RE.matcher(segment).replaceAll("/") : segment;
    }

    private void updateMatch(HttpServerExchange exchange, String segment) {
        exchange.setRelativePath(exchange.getRelativePath().substring(segment.length() + 1));
        exchange.setResolvedPath(exchange.getResolvedPath() + "/" + segment);
    }

    public static final class Builder {
        private Option<HttpHandler> hereHandler = API.None();
        private Map<String, HttpHandler> exactSegments = API.Map();
        private Option<Tuple2<Seq<? extends BiConsumer<? super HttpServerExchange, ? super String>>, HttpHandler>> capture = API.None();
        private HttpHandler defaultHandler = ResponseCodeHandler.HANDLE_404;

        private Builder() {
        }

        public Builder hereHandler(HttpHandler hereHandler) {
            this.hereHandler = API.Some((Object)hereHandler);
            return this;
        }

        public Builder exactSegment(String segment, HttpHandler handler) {
            this.exactSegments = this.exactSegments.put((Object)segment, (Object)handler);
            return this;
        }

        public Builder capture(BiConsumer<? super HttpServerExchange, ? super String> capture, HttpHandler handler) {
            this.capture = API.Some((Object)API.Tuple((Object)API.Seq(capture), (Object)handler));
            return this;
        }

        public Builder capture(Seq<? extends BiConsumer<? super HttpServerExchange, ? super String>> capture, HttpHandler handler) {
            this.capture = API.Some((Object)API.Tuple(capture, (Object)handler));
            return this;
        }

        public Builder defaultHandler(HttpHandler defaultHandler) {
            this.defaultHandler = defaultHandler;
            return this;
        }

        public PathSegmentHandler build() {
            return new PathSegmentHandler(this.hereHandler, this.exactSegments, this.capture, this.defaultHandler);
        }
    }
}

