/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.routing;

import ch.raffael.meldioc.library.http.server.undertow.codec.EmptyBody;
import ch.raffael.meldioc.library.http.server.undertow.codec.HttpDecoder;
import ch.raffael.meldioc.library.http.server.undertow.codec.HttpEncoder;
import ch.raffael.meldioc.library.http.server.undertow.handler.ActionHandler;
import ch.raffael.meldioc.library.http.server.undertow.handler.DispatchMode;
import ch.raffael.meldioc.library.http.server.undertow.handler.HttpMethodHandler;
import ch.raffael.meldioc.library.http.server.undertow.routing.Capture;
import ch.raffael.meldioc.library.http.server.undertow.routing.Frame;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.vavr.collection.Set;
import java.util.function.Function;

public class ActionBuilder<C, B, R> {
    final Frame<C> frame;
    final Set<HttpMethodHandler.Method> methods;
    final Function<? super Frame<? super C>, ? extends HttpDecoder<? super C, ? extends B>> decoder;
    final Function<? super Frame<? super C>, ? extends HttpEncoder<? super C, ? super R>> encoder;
    DispatchMode dispatch;

    ActionBuilder(Frame<C> frame, Set<HttpMethodHandler.Method> methods, Function<? super Frame<? super C>, ? extends HttpDecoder<? super C, ? extends B>> decoder, Function<? super Frame<? super C>, ? extends HttpEncoder<? super C, ? super R>> encoder, DispatchMode dispatch) {
        this.frame = frame;
        this.methods = methods;
        this.decoder = decoder;
        this.encoder = encoder;
        this.dispatch = dispatch;
    }

    public ActionBuilder<C, B, R> nonBlocking() {
        this.dispatch = DispatchMode.NON_BLOCKING;
        return this;
    }

    void conclude(ActionHandler.Invoker<C, B, R> invoker) {
        this.methods.forEach(m -> this.frame.action((HttpMethodHandler.Method)((Object)m), new LazyActionHandler(this.decoder, this.encoder, invoker, this.dispatch)));
    }

    static final class LazyActionHandler<C, B, R> {
        final Function<? super Frame<? super C>, ? extends HttpDecoder<? super C, ? extends B>> decoder;
        final Function<? super Frame<? super C>, ? extends HttpEncoder<? super C, ? super R>> encoder;
        final ActionHandler.Invoker<C, B, R> invoker;
        final DispatchMode dispatch;

        LazyActionHandler(Function<? super Frame<? super C>, ? extends HttpDecoder<? super C, ? extends B>> decoder, Function<? super Frame<? super C>, ? extends HttpEncoder<? super C, ? super R>> encoder, ActionHandler.Invoker<C, B, R> invoker, DispatchMode dispatch) {
            this.decoder = decoder;
            this.encoder = encoder;
            this.invoker = invoker;
            this.dispatch = dispatch;
        }

        HttpHandler handler(Function<? super HttpServerExchange, ? extends C> contextFun, Frame<C> frame) {
            return new ActionHandler<C, B, R>(this.decoder.apply(frame), this.encoder.apply(frame), contextFun, this.invoker, this.dispatch);
        }

        <CC extends C> LazyActionHandler<CC, B, R> covariant() {
            return this;
        }
    }

    public static final class Some2Some<C, B, R>
    extends ActionBuilder<C, B, R> {
        Some2Some(Frame<C> frame, Set<HttpMethodHandler.Method> methods, Function<? super Frame<? super C>, ? extends HttpDecoder<? super C, ? extends B>> decoder, Function<? super Frame<? super C>, ? extends HttpEncoder<? super C, ? super R>> encoder, DispatchMode dispatch) {
            super(frame, methods, decoder, encoder, dispatch);
        }

        public <BB> Some2Some<C, BB, R> acceptWith(HttpDecoder<? super C, ? extends BB> decoder) {
            return this.withDecoder(__ -> decoder);
        }

        public Some2Some<C, ? super String, R> acceptPlainText() {
            return this.withDecoder(f -> f.dec.plainText());
        }

        public <T> Some2Some<C, T, R> accept(Class<T> type) {
            return this.withDecoder(f -> f.dec.object(type));
        }

        private <RR> Some2Some<C, B, RR> produceWith(Function<Frame<? super C>, ? extends HttpEncoder<? super C, ? super RR>> encoder) {
            return new Some2Some<C, B, R>(this.frame, (Set<HttpMethodHandler.Method>)this.methods, this.decoder, encoder, this.dispatch);
        }

        public <RR> Some2Some<C, B, RR> produceWith(HttpEncoder<? super C, ? super RR> encoder) {
            return this.produceWith((Frame<? super C> __) -> encoder);
        }

        public Some2Some<C, B, CharSequence> producePlainText() {
            return this.produceWith((Frame<? super C> f) -> f.enc.plainText());
        }

        public Some2Some<C, B, CharSequence> produceHtml() {
            return this.produceWith((Frame<? super C> f) -> f.enc.html());
        }

        public Some2Some<C, B, Object> produceObject() {
            return this.produceWith((Frame<? super C> f) -> f.enc.object(Object.class));
        }

        public <T> Some2Some<C, B, T> produce(Class<T> type) {
            return this.produceWith((Frame<? super C> f) -> f.enc.object(type));
        }

        @Override
        public Some2Some<C, B, R> nonBlocking() {
            super.nonBlocking();
            return this;
        }

        public void apply(ActionC1R<? super C, ? super B, ? extends R> action) {
            this.conclude((x, c, b) -> action.perform((Object)c, (Object)b));
        }

        public <P1> void apply(Capture<P1> p1, ActionC2R<? super C, ? super B, ? super P1, ? extends R> action) {
            this.conclude((x, c, b) -> action.perform((Object)c, (Object)b, (Object)p1.get(x)));
        }

        public <P1, P2> void apply(Capture<P1> p1, Capture<P2> p2, ActionC3R<? super C, ? super B, ? super P1, ? super P2, ? extends R> action) {
            this.conclude((x, c, b) -> action.perform((Object)c, (Object)b, (Object)p1.get(x), (Object)p2.get(x)));
        }

        public void apply(Action1R<? super B, ? extends R> action) {
            this.conclude((x, c, b) -> action.perform((Object)b));
        }

        public <P1> void apply(Capture<P1> p1, Action2R<? super B, ? super P1, ? extends R> action) {
            this.conclude((x, c, b) -> action.perform((Object)b, (Object)p1.get(x)));
        }

        public <P1, P2> void apply(Capture<P1> p1, Capture<P2> p2, Action3R<? super B, ? super P1, ? super P2, ? extends R> action) {
            this.conclude((x, c, b) -> action.perform((Object)b, (Object)p1.get(x), (Object)p2.get(x)));
        }

        private <BB> Some2Some<C, BB, R> withDecoder(Function<? super Frame<? super C>, ? extends HttpDecoder<? super C, ? extends BB>> decoder) {
            return new Some2Some<C, B, R>(this.frame, (Set<HttpMethodHandler.Method>)this.methods, decoder, this.encoder, this.dispatch);
        }
    }

    public static final class Some2None<C, B>
    extends ActionBuilder<C, B, EmptyBody> {
        Some2None(Frame<C> frame, Set<HttpMethodHandler.Method> methods, Function<? super Frame<? super C>, ? extends HttpDecoder<? super C, ? extends B>> decoder, DispatchMode dispatch) {
            super(frame, methods, decoder, __ -> EmptyBody.encoder(), dispatch);
        }

        public <RR> Some2Some<C, B, RR> produceWith(HttpEncoder<? super C, ? super RR> encoder) {
            return this.withEncoder(__ -> encoder);
        }

        public Some2Some<C, B, CharSequence> producePlainText() {
            return this.withEncoder(f -> f.enc.plainText());
        }

        public Some2Some<C, B, CharSequence> produceHtml() {
            return this.withEncoder(f -> f.enc.html());
        }

        public Some2Some<C, B, Object> produceObject() {
            return this.withEncoder(f -> f.enc.object(Object.class));
        }

        public <T> Some2Some<C, B, T> produce(Class<T> type) {
            return this.withEncoder(f -> f.enc.object(type));
        }

        public Some2None<C, B> nonBlocking() {
            super.nonBlocking();
            return this;
        }

        public void apply(ActionC1<? super C, ? super B> action) {
            this.conclude((x, c, b) -> {
                action.perform((Object)c, (Object)b);
                return EmptyBody.empty();
            });
        }

        public <P1> void apply(Capture<P1> p1, ActionC2<? super C, ? super B, ? super P1> action) {
            this.conclude((x, c, b) -> {
                action.perform((Object)c, (Object)b, (Object)p1.get(x));
                return EmptyBody.empty();
            });
        }

        public <P1, P2> void apply(Capture<P1> p1, Capture<P2> p2, ActionC3<? super C, ? super B, ? super P1, ? super P2> action) {
            this.conclude((x, c, b) -> {
                action.perform((Object)c, (Object)b, (Object)p1.get(x), (Object)p2.get(x));
                return EmptyBody.empty();
            });
        }

        public <P1> void apply(Action1<? super B> action) {
            this.conclude((x, c, b) -> {
                action.perform((Object)b);
                return EmptyBody.empty();
            });
        }

        public <P1> void apply(Capture<P1> p1, Action2<? super B, ? super P1> action) {
            this.conclude((x, c, b) -> {
                action.perform((Object)b, (Object)p1.get(x));
                return EmptyBody.empty();
            });
        }

        public <P1, P2> void apply(Capture<P1> p1, Capture<P2> p2, Action3<? super B, ? super P1, ? super P2> action) {
            this.conclude((x, c, b) -> {
                action.perform((Object)b, (Object)p1.get(x), (Object)p2.get(x));
                return EmptyBody.empty();
            });
        }

        private <RR> Some2Some<C, B, RR> withEncoder(Function<? super Frame<? super C>, ? extends HttpEncoder<? super C, ? super RR>> encoder) {
            return new Some2Some(this.frame, (Set<HttpMethodHandler.Method>)this.methods, this.decoder, encoder, this.dispatch);
        }
    }

    public static final class None2Some<C, R>
    extends ActionBuilder<C, EmptyBody, R> {
        None2Some(Frame<C> frame, Set<HttpMethodHandler.Method> methods, Function<? super Frame<? super C>, ? extends HttpEncoder<? super C, ? super R>> encoder, DispatchMode dispatch) {
            super(frame, methods, __ -> EmptyBody.decoder(), encoder, dispatch);
        }

        public <BB> Some2Some<C, BB, R> withDecoder(HttpDecoder<? super C, ? extends BB> decoder) {
            return this.withDecoder((? super Frame<? super C> __) -> decoder);
        }

        public Some2Some<C, ? super String, R> acceptPlainText() {
            return this.withDecoder((? super Frame<? super C> f) -> f.dec.plainText());
        }

        public <T> Some2Some<C, T, R> accept(Class<T> type) {
            return this.withDecoder((? super Frame<? super C> f) -> f.dec.object(type));
        }

        public None2Some<C, R> nonBlocking() {
            super.nonBlocking();
            return this;
        }

        public void apply(ActionC0R<? super C, ? extends R> action) {
            this.conclude((x, c, b) -> action.perform(c));
        }

        public void apply(Action0R<? extends R> action) {
            this.conclude((x, c, b) -> action.perform());
        }

        public <P1> void apply(Capture<P1> p1, ActionC1R<? super C, ? super P1, ? extends R> action) {
            this.conclude((x, c, b) -> action.perform((Object)c, (Object)p1.get(x)));
        }

        public <P1, P2> void apply(Capture<P1> p1, Capture<P2> p2, ActionC2R<? super C, ? super P1, ? super P2, ? extends R> action) {
            this.conclude((x, c, b) -> action.perform((Object)c, (Object)p1.get(x), (Object)p2.get(x)));
        }

        public <P1, P2, P3> void apply(Capture<P1> p1, Capture<P2> p2, Capture<P3> p3, ActionC3R<? super C, ? super P1, ? super P2, ? super P3, ? extends R> action) {
            this.conclude((x, c, b) -> action.perform((Object)c, (Object)p1.get(x), (Object)p2.get(x), (Object)p3.get(x)));
        }

        public <P1> void apply(Capture<P1> p1, Action1R<? super P1, ? extends R> action) {
            this.conclude((x, c, b) -> action.perform((Object)p1.get(x)));
        }

        public <P1, P2> void apply(Capture<P1> p1, Capture<P2> p2, Action2R<? super P1, ? super P2, ? extends R> action) {
            this.conclude((x, c, b) -> action.perform((Object)p1.get(x), (Object)p2.get(x)));
        }

        public <P1, P2, P3> void apply(Capture<P1> p1, Capture<P2> p2, Capture<P3> p3, Action3R<? super P1, ? super P2, ? super P3, ? extends R> action) {
            this.conclude((x, c, b) -> action.perform((Object)p1.get(x), (Object)p2.get(x), (Object)p3.get(x)));
        }

        private <BB> Some2Some<C, BB, R> withDecoder(Function<? super Frame<? super C>, ? extends HttpDecoder<? super C, ? extends BB>> decoder) {
            return new Some2Some(this.frame, (Set<HttpMethodHandler.Method>)this.methods, decoder, this.encoder, this.dispatch);
        }
    }

    public static final class None2None<C>
    extends ActionBuilder<C, EmptyBody, EmptyBody> {
        None2None(Frame<C> frame, Set<HttpMethodHandler.Method> methods, DispatchMode dispatch) {
            super(frame, methods, __ -> EmptyBody.decoder(), __ -> EmptyBody.encoder(), dispatch);
        }

        public <BB> Some2None<C, BB> acceptWith(HttpDecoder<? super C, ? extends BB> decoder) {
            return this.withDecoder(__ -> decoder);
        }

        public Some2None<C, ? super String> acceptPlainText() {
            return this.withDecoder(f -> f.dec.plainText());
        }

        public <T> Some2None<C, T> accept(Class<T> type) {
            return this.withDecoder(f -> f.dec.object(type));
        }

        public <RR> None2Some<C, RR> produceWith(HttpEncoder<? super C, ? super RR> encoder) {
            return this.withEncoder(__ -> encoder);
        }

        public None2Some<C, CharSequence> producePlainText() {
            return this.withEncoder(f -> f.enc.plainText());
        }

        public None2Some<C, CharSequence> produceHtml() {
            return this.withEncoder(f -> f.enc.html());
        }

        public None2Some<C, Object> produceObject() {
            return this.withEncoder(f -> f.enc.object(Object.class));
        }

        public <T> None2Some<C, T> produce(Class<T> type) {
            return this.withEncoder(f -> f.enc.object(type));
        }

        public None2None<C> nonBlocking() {
            super.nonBlocking();
            return this;
        }

        public void apply(ActionC0<? super C> action) {
            this.conclude((x, c, b) -> {
                action.perform(c);
                return EmptyBody.empty();
            });
        }

        public <P1> void apply(Capture<P1> p1, ActionC1<? super C, ? super P1> action) {
            this.conclude((x, c, b) -> {
                action.perform((Object)c, (Object)p1.get(x));
                return EmptyBody.empty();
            });
        }

        public <P1, P2> void apply(Capture<P1> p1, Capture<P2> p2, ActionC2<? super C, ? super P1, ? super P2> action) {
            this.conclude((x, c, b) -> {
                action.perform((Object)c, (Object)p1.get(x), (Object)p2.get(x));
                return EmptyBody.empty();
            });
        }

        public <P1, P2, P3> void apply(Capture<P1> p1, Capture<P2> p2, Capture<P3> p3, ActionC3<? super C, ? super P1, ? super P2, ? super P3> action) {
            this.conclude((x, c, b) -> {
                action.perform((Object)c, (Object)p1.get(x), (Object)p2.get(x), (Object)p3.get(x));
                return EmptyBody.empty();
            });
        }

        public void apply(Action0 action) {
            this.conclude((x, c, b) -> {
                action.perform();
                return EmptyBody.empty();
            });
        }

        public <P1> void apply(Capture<P1> p1, Action1<? super P1> action) {
            this.conclude((x, c, b) -> {
                action.perform((Object)p1.get(x));
                return EmptyBody.empty();
            });
        }

        public <P1, P2> void apply(Capture<P1> p1, Capture<P2> p2, Action2<? super P1, ? super P2> action) {
            this.conclude((x, c, b) -> {
                action.perform((Object)p1.get(x), (Object)p2.get(x));
                return EmptyBody.empty();
            });
        }

        public <P1, P2, P3> void apply(Capture<P1> p1, Capture<P2> p2, Capture<P3> p3, Action3<? super P1, ? super P2, ? super P3> action) {
            this.conclude((x, c, b) -> {
                action.perform((Object)p1.get(x), (Object)p2.get(x), (Object)p3.get(x));
                return EmptyBody.empty();
            });
        }

        private <BB> Some2None<C, BB> withDecoder(Function<? super Frame<? super C>, ? extends HttpDecoder<? super C, ? extends BB>> decoder) {
            return new Some2None(this.frame, (Set<HttpMethodHandler.Method>)this.methods, decoder, this.dispatch);
        }

        private <RR> None2Some<C, RR> withEncoder(Function<? super Frame<? super C>, ? extends HttpEncoder<? super C, ? super RR>> encoder) {
            return new None2Some(this.frame, (Set<HttpMethodHandler.Method>)this.methods, encoder, this.dispatch);
        }
    }

    @FunctionalInterface
    public static interface Action3<P1, P2, P3> {
        public void perform(P1 var1, P2 var2, P3 var3) throws Exception;
    }

    @FunctionalInterface
    public static interface Action2<P1, P2> {
        public void perform(P1 var1, P2 var2) throws Exception;
    }

    @FunctionalInterface
    public static interface Action1<P1> {
        public void perform(P1 var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Action0 {
        public void perform() throws Exception;
    }

    @FunctionalInterface
    public static interface ActionC3<C, P1, P2, P3> {
        public void perform(C var1, P1 var2, P2 var3, P3 var4) throws Exception;
    }

    @FunctionalInterface
    public static interface ActionC2<C, P1, P2> {
        public void perform(C var1, P1 var2, P2 var3) throws Exception;
    }

    @FunctionalInterface
    public static interface ActionC1<C, P1> {
        public void perform(C var1, P1 var2) throws Exception;
    }

    @FunctionalInterface
    public static interface ActionC0<C> {
        public void perform(C var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Action3R<P1, P2, P3, R> {
        public R perform(P1 var1, P2 var2, P3 var3) throws Exception;
    }

    @FunctionalInterface
    public static interface Action2R<P1, P2, R> {
        public R perform(P1 var1, P2 var2) throws Exception;
    }

    @FunctionalInterface
    public static interface Action1R<P1, R> {
        public R perform(P1 var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Action0R<R> {
        public R perform() throws Exception;
    }

    @FunctionalInterface
    public static interface ActionC3R<C, P1, P2, P3, R> {
        public R perform(C var1, P1 var2, P2 var3, P3 var4) throws Exception;
    }

    @FunctionalInterface
    public static interface ActionC2R<C, P1, P2, R> {
        public R perform(C var1, P1 var2, P2 var3) throws Exception;
    }

    @FunctionalInterface
    public static interface ActionC1R<C, P1, R> {
        public R perform(C var1, P1 var2) throws Exception;
    }

    @FunctionalInterface
    public static interface ActionC0R<C, R> {
        public R perform(C var1) throws Exception;
    }
}

