/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.routing;

import ch.raffael.meldioc.library.http.server.undertow.routing.RoutingDefinitionException;
import io.vavr.API;
import io.vavr.collection.Array;
import java.util.regex.Pattern;

final class Paths {
    private static final Pattern PATH_SPLIT = Pattern.compile("/");

    private Paths() {
    }

    static String normalize(String path) {
        if (Paths.empty(path)) {
            return path;
        }
        if (path.contains("//")) {
            throw new RoutingDefinitionException("Illegal path: " + path);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    static String normalizeLeadingSlash(String path) {
        return !(path = Paths.normalize(path)).startsWith("/") ? "/" + path : path;
    }

    static String normalizeStripLeadingSlash(String path) {
        return (path = Paths.normalize(path)).startsWith("/") ? path.substring(1) : path;
    }

    static Array<String> segments(String path) {
        return Paths.empty(path) ? API.Array() : API.Array((Object[])PATH_SPLIT.split(Paths.normalizeStripLeadingSlash(path)));
    }

    static boolean empty(String path) {
        return path.isEmpty() || path.equals("/");
    }
}

