/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.routing;

import ch.raffael.meldioc.library.codec.ObjectCodecFactory;
import ch.raffael.meldioc.library.http.server.undertow.codec.HttpObjectCodecFactory;
import ch.raffael.meldioc.library.http.server.undertow.handler.AccessCheckHandler;
import ch.raffael.meldioc.library.http.server.undertow.handler.DispatchMode;
import ch.raffael.meldioc.library.http.server.undertow.handler.HttpMethodHandler;
import ch.raffael.meldioc.library.http.server.undertow.routing.ActionBuilder;
import ch.raffael.meldioc.library.http.server.undertow.routing.Frame;
import ch.raffael.meldioc.library.http.server.undertow.routing.QueryCaptureBuilder;
import ch.raffael.meldioc.library.http.server.undertow.routing.RoutingBuilder;
import ch.raffael.meldioc.library.http.server.undertow.security.Role;
import io.vavr.API;
import io.vavr.collection.Set;
import io.vavr.control.Option;
import java.util.function.Function;

public abstract class RoutingDefinition<C> {
    Frame<C> rootFrame;
    Frame<C> currentFrame = new Frame(this, API.None());

    protected RoutingDefinition() {
        this.rootFrame = this.currentFrame;
    }

    public static <C> RoutingDefinition<C> empty() {
        class Empty
        extends RoutingDefinition<C> {
            Empty() {
            }
        }
        return new Empty();
    }

    public RoutingBuilder.InitialFragment path() {
        return RoutingBuilder.begin(this.currentFrame);
    }

    public RoutingBuilder.Fragment0 path(String path) {
        return RoutingBuilder.begin(this.currentFrame).path(path);
    }

    public QueryCaptureBuilder query(String name) {
        return new QueryCaptureBuilder(name);
    }

    public ActionBuilder.None2None<C> handle(HttpMethodHandler.Method ... methods) {
        return new ActionBuilder.None2None<C>(this.currentFrame, (Set<HttpMethodHandler.Method>)API.Set((Object[])methods), DispatchMode.DISPATCH);
    }

    public ActionBuilder.None2None<C> get() {
        return this.handle(HttpMethodHandler.Method.GET);
    }

    public ActionBuilder.None2None<C> post() {
        return this.handle(HttpMethodHandler.Method.POST);
    }

    public ActionBuilder.None2None<C> put() {
        return this.handle(HttpMethodHandler.Method.PUT);
    }

    public ActionBuilder.None2None<C> delete() {
        return this.handle(HttpMethodHandler.Method.DELETE);
    }

    public void restrict(AccessCheckHandler.AccessRestriction value) {
        this.currentFrame.restriction = API.Some((Object)value);
    }

    public <R extends Role> void restrict(Function<? super String, ? extends Option<? extends R>> mapper, Set<? extends R> roles) {
        this.restrict(AccessCheckHandler.accessByRole(mapper, roles));
    }

    @SafeVarargs
    public final <R extends Role> void restrict(Function<? super String, ? extends Option<? extends R>> mapper, R ... roles) {
        this.restrict(AccessCheckHandler.accessByRole(mapper, API.Set((Object[])roles)));
    }

    public <R extends Enum> void restrict(Class<R> roleEnum, Set<? extends R> roles) {
        this.restrict(AccessCheckHandler.accessByRole(roleEnum, roles));
    }

    @SafeVarargs
    public final <R extends Enum> void restrict(Class<R> roleEnum, R ... roles) {
        this.restrict(AccessCheckHandler.accessByRole(roleEnum, API.Set((Object[])roles)));
    }

    public void objectCodec(HttpObjectCodecFactory<? super C> objectCodecFactory) {
        this.currentFrame.objectCodecFactory = API.Some(objectCodecFactory);
    }

    public void objectCodec(ObjectCodecFactory objectCodecFactory) {
        this.objectCodec(HttpObjectCodecFactory.wrapBuffered(objectCodecFactory));
    }

    public void merge(RoutingDefinition<? super C> that) {
        this.currentFrame.merge(that.rootFrame);
    }
}

