/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.util;

import ch.raffael.meldioc.library.http.server.undertow.handler.ErrorMessageHandler;
import ch.raffael.meldioc.logging.Logging;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import org.slf4j.Logger;

public class HttpStatusException
extends Exception {
    private static final Logger LOG = Logging.logger();
    private final int statusCode;

    public HttpStatusException(int statusCode, String message) {
        super(message);
        this.statusCode = statusCode;
    }

    public HttpStatusException(int statusCode, String message, Throwable cause) {
        super(message, cause);
        this.statusCode = statusCode;
    }

    public HttpStatusException(int statusCode, Throwable cause) {
        super(cause.toString(), cause);
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public static HttpStatusException badRequest() {
        return HttpStatusException.badRequest("Bad request");
    }

    public static HttpStatusException badRequest(String message) {
        return new HttpStatusException(400, message);
    }

    public static HttpStatusException badRequest(String message, Throwable cause) {
        return new HttpStatusException(400, message, cause);
    }

    public static HttpStatusException badRequest(Throwable cause) {
        return new HttpStatusException(400, cause);
    }

    public static HttpStatusException serverError(String message) {
        return new HttpStatusException(500, message);
    }

    public static HttpStatusException serverError(String message, Throwable cause) {
        return new HttpStatusException(500, message, cause);
    }

    public static HttpStatusException serverError(Throwable cause) {
        return new HttpStatusException(500, cause);
    }

    public void endRequest(HttpServerExchange exchange) {
        String msg = this.getLocalizedMessage();
        LOG.debug("Returning {}: {}", new Object[]{this.getStatusCode(), msg, this});
        exchange.setStatusCode(this.getStatusCode());
        ErrorMessageHandler.addMessage(exchange, msg);
    }

    public static void endRequestWithServerError(HttpServerExchange exchange, Throwable exception) {
        new HttpStatusException(500, exception).endRequest(exchange);
    }

    public static void endRequestWithBadRequest(HttpServerExchange exchange, Throwable exception) {
        new HttpStatusException(400, exception).endRequest(exchange);
    }

    public static void endRequestWithBadRequest(HttpServerExchange exchange, String message) {
        new HttpStatusException(400, message).endRequest(exchange);
    }

    public static class Handler
    implements HttpHandler {
        private final HttpHandler next;

        public Handler(HttpHandler next) {
            this.next = next;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            try {
                this.next.handleRequest(exchange);
            }
            catch (HttpStatusException e) {
                e.endRequest(exchange);
            }
        }
    }
}

