/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow;

import ch.raffael.meldioc.ExtensionPoint;
import ch.raffael.meldioc.library.http.server.undertow.handler.DispatchToWorkerHandler;
import ch.raffael.meldioc.library.http.server.undertow.handler.ErrorMessageHandler;
import ch.raffael.meldioc.library.http.server.undertow.routing.RoutingDefinition;
import ch.raffael.meldioc.library.http.server.undertow.routing.RoutingDefinitions;
import ch.raffael.meldioc.library.http.server.undertow.util.RequestContextStore;
import io.undertow.Undertow;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.vavr.collection.Seq;
import io.vavr.control.Option;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;

@ExtensionPoint.Acceptor
public final class UndertowBlueprint<C> {
    public static final String ADDRESS_ALL = "0.0.0.0";
    public static final String ADDRESS_LOCAL = "localhost";
    private static final BiFunction<Object, HttpHandler, HttpHandler> DISPATCH = (__, n) -> new DispatchToWorkerHandler((HttpHandler)n);
    private static final BiFunction<Object, HttpHandler, HttpHandler> COMPRESS = (__, n) -> new EncodingHandler.Builder().build(Map.of()).wrap(n);
    private static final BiFunction<Object, HttpHandler, HttpHandler> ERROR = (__, n) -> new ErrorMessageHandler((HttpHandler)n);
    private Seq<Consumer<? super Undertow.Builder>> listeners = io.vavr.collection.List.empty();
    private Seq<BiFunction<? super Function<? super HttpServerExchange, ? extends C>, ? super HttpHandler, ? extends HttpHandler>> handlerChain = io.vavr.collection.List.of((Object[])new BiFunction[]{DISPATCH, COMPRESS, ERROR});
    @Nullable
    private Function<? super Function<? super HttpServerExchange, ? extends C>, ? extends HttpHandler> mainHandler = null;
    @Nullable
    private Function<? super HttpServerExchange, ? extends C> contextFactory;
    private Seq<Consumer<? super Undertow>> postConstruct = io.vavr.collection.List.empty();
    private Seq<Consumer<? super Undertow>> postStart = io.vavr.collection.List.empty();

    public static <C> EP<C> holder() {
        return UndertowBlueprint.holder(Undertow::builder);
    }

    public static <C> EP<C> holder(Supplier<? extends Undertow.Builder> undertowBuilderSupplier) {
        return new EP<C>(new UndertowBlueprint<C>(), undertowBuilderSupplier);
    }

    public UndertowBlueprint<C> httpAll(int port) {
        return this.http(ADDRESS_ALL, port);
    }

    public UndertowBlueprint<C> httpLocal(int port) {
        return this.http(ADDRESS_LOCAL, port);
    }

    public UndertowBlueprint<C> http(String address, int port) {
        this.listeners = this.listeners.append(b -> b.addHttpListener(port, address));
        return this;
    }

    public synchronized UndertowBlueprint<C> httpAllSecure(int port, SSLContext sslContext) {
        return this.httpSecure(ADDRESS_ALL, port, sslContext);
    }

    public synchronized UndertowBlueprint<C> httpLocalSecure(int port, SSLContext sslContext) {
        return this.httpSecure(ADDRESS_LOCAL, port, sslContext);
    }

    public synchronized UndertowBlueprint<C> httpSecure(String address, int port, SSLContext sslContext) {
        this.listeners = this.listeners.append(b -> b.addHttpsListener(port, address, sslContext));
        return this;
    }

    public UndertowBlueprint<C> handler(BiFunction<? super Function<? super HttpServerExchange, ? extends C>, ? super HttpHandler, ? extends HttpHandler> handler) {
        this.handlerChain = this.handlerChain.append(handler);
        return this;
    }

    public UndertowBlueprint<C> handler(Function<? super HttpHandler, ? extends HttpHandler> handler) {
        this.handlerChain = this.handlerChain.append((__, n) -> (HttpHandler)handler.apply((HttpHandler)n));
        return this;
    }

    public UndertowBlueprint<C> prependHandler(BiFunction<? super Function<? super HttpServerExchange, ? extends C>, ? super HttpHandler, ? extends HttpHandler> handler) {
        this.handlerChain = this.handlerChain.prepend(handler);
        return this;
    }

    public UndertowBlueprint<C> prependHandler(Function<? super HttpHandler, ? extends HttpHandler> handler) {
        this.handlerChain = this.handlerChain.prepend((__, n) -> (HttpHandler)handler.apply((HttpHandler)n));
        return this;
    }

    public SecurityBuilder<C> security(IdentityManager identityManager) {
        return new SecurityBuilder(this, identityManager);
    }

    public UndertowBlueprint<C> security(IdentityManager identityManager, AuthenticationMechanism ... mechanisms) {
        return new SecurityBuilder(this, identityManager).mechanism(mechanisms).end();
    }

    public UndertowBlueprint<C> security(IdentityManager identityManager, Iterable<? extends AuthenticationMechanism> mechanisms) {
        return new SecurityBuilder(this, identityManager).mechanism(mechanisms).end();
    }

    public UndertowBlueprint<C> basicSecurity(IdentityManager identityManager) {
        return new SecurityBuilder(this, identityManager).basicAuth().end();
    }

    public UndertowBlueprint<C> basicSecurity(IdentityManager identityManager, String realm) {
        return new SecurityBuilder(this, identityManager).basicAuth(realm).end();
    }

    public UndertowBlueprint<C> customMainHandler(Function<? super Function<? super HttpServerExchange, ? extends C>, ? extends HttpHandler> mainHandler) {
        this.mainHandler = mainHandler;
        return this;
    }

    public UndertowBlueprint<C> routing(Supplier<? extends RoutingDefinition<? super C>> routing) {
        return this.customMainHandler(ctx -> RoutingDefinitions.buildHandlerTree((RoutingDefinition)routing.get(), ctx));
    }

    @Deprecated(forRemoval=true)
    public UndertowBlueprint<C> mainHandler(Function<? super Function<? super HttpServerExchange, ? extends C>, ? extends HttpHandler> mainHandler) {
        this.customMainHandler(mainHandler);
        return this;
    }

    @Deprecated(forRemoval=true)
    public UndertowBlueprint<C> mainHandler(RoutingDefinition<? super C> routing) {
        return this.routing(() -> routing);
    }

    public UndertowBlueprint<C> disableCompression() {
        this.handlerChain = this.handlerChain.remove(COMPRESS);
        return this;
    }

    public UndertowBlueprint<C> disableStandardErrorHandler() {
        this.handlerChain = this.handlerChain.remove(ERROR);
        return this;
    }

    public UndertowBlueprint<C> disableEarlyDispatch() {
        this.handlerChain = this.handlerChain.remove(DISPATCH);
        return this;
    }

    public UndertowBlueprint<C> suppressStackTraces() {
        return this.suppressStackTraces(true);
    }

    public UndertowBlueprint<C> suppressStackTraces(boolean suppress) {
        if (suppress) {
            this.handlerChain = this.handlerChain.prepend((__, n) -> ErrorMessageHandler.ExceptionRenderer.suppressStackTracesHandler(n));
        }
        return this;
    }

    public UndertowBlueprint<C> suppressStackTraces(Supplier<Boolean> suppress) {
        this.handlerChain = this.handlerChain.prepend((__, n) -> ErrorMessageHandler.ExceptionRenderer.suppressStackTracesHandler(n, suppress));
        return this;
    }

    public UndertowBlueprint<C> suppressStackTraces(Predicate<? super HttpServerExchange> suppress) {
        this.handlerChain = this.handlerChain.prepend((__, n) -> ErrorMessageHandler.ExceptionRenderer.suppressStackTracesHandler(n, suppress));
        return this;
    }

    public UndertowBlueprint<C> clearHandlerChain() {
        this.handlerChain = io.vavr.collection.List.empty();
        return this;
    }

    public UndertowBlueprint<C> addCompressionHandler() {
        return this.addStandardHandler(COMPRESS);
    }

    public UndertowBlueprint<C> addStandardErrorHandler() {
        return this.addStandardHandler(ERROR);
    }

    public UndertowBlueprint<C> addDispatchHandler() {
        return this.addStandardHandler(DISPATCH);
    }

    private UndertowBlueprint<C> addStandardHandler(BiFunction<Object, HttpHandler, HttpHandler> handler) {
        if (!this.handlerChain.contains(handler)) {
            this.handlerChain = this.handlerChain.append(handler);
        }
        return this;
    }

    public UndertowBlueprint<C> requestContextFactory(Function<? super HttpServerExchange, ? extends C> factory) {
        this.contextFactory = factory;
        return this;
    }

    public UndertowBlueprint<C> requestContextFactory(Supplier<? extends C> factory) {
        return this.requestContextFactory((? super HttpServerExchange __) -> factory.get());
    }

    public UndertowBlueprint<C> postConstruct(Consumer<? super Undertow> consumer) {
        this.postConstruct = this.postConstruct.append(consumer);
        return this;
    }

    public UndertowBlueprint<C> postStart(Consumer<? super Undertow> consumer) {
        this.postStart = this.postStart.append(consumer);
        return this;
    }

    public static class EP<C> {
        private final UndertowBlueprint<C> blueprint;
        private final Supplier<? extends Undertow.Builder> undertowBuilderSupplier;

        protected EP(UndertowBlueprint<C> blueprint, Supplier<? extends Undertow.Builder> undertowBuilderSupplier) {
            this.blueprint = blueprint;
            this.undertowBuilderSupplier = undertowBuilderSupplier;
        }

        public UndertowBlueprint<C> acceptor() {
            return this.blueprint;
        }

        public EP<C> withRequestContextFactory(Function<? super HttpServerExchange, ? extends C> factory) {
            this.blueprint.requestContextFactory(factory);
            return this;
        }

        protected Undertow apply() {
            return this.autoStart(this.blueprint, this.build(this.blueprint, this.prepareBuilder(this.blueprint)));
        }

        protected Undertow.Builder prepareBuilder(UndertowBlueprint<C> acceptor) {
            if (acceptor.contextFactory == null) {
                throw new IllegalStateException("No request context factory");
            }
            RequestContextStore contextStore = new RequestContextStore(acceptor.contextFactory);
            if (acceptor.listeners.isEmpty()) {
                throw new IllegalStateException("No listeners");
            }
            if (acceptor.mainHandler == null) {
                throw new IllegalStateException("No main handler");
            }
            Undertow.Builder builder = this.undertowBuilderSupplier.get();
            acceptor.listeners.forEach(l -> l.accept(builder));
            builder.setHandler((HttpHandler)acceptor.handlerChain.foldRight((Object)acceptor.mainHandler.apply(contextStore), (self, next) -> (HttpHandler)self.apply(contextStore, next)));
            return builder;
        }

        protected Undertow build(UndertowBlueprint<C> acceptor, Undertow.Builder builder) {
            Undertow undertow = builder.build();
            acceptor.postConstruct.forEach(h -> h.accept(undertow));
            return undertow;
        }

        protected Undertow start(UndertowBlueprint<C> acceptor, Undertow undertow) {
            undertow.start();
            this.blueprint.postStart.forEach(h -> h.accept(undertow));
            return undertow;
        }

        protected Undertow autoStart(UndertowBlueprint<C> acceptor, Undertow undertow) {
            return this.start(acceptor, undertow);
        }
    }

    public static final class SecurityBuilder<C> {
        private final UndertowBlueprint<C> parent;
        private final IdentityManager identityManager;
        private AuthenticationMode authenticationMode = AuthenticationMode.CONSTRAINT_DRIVEN;
        private Seq<AuthenticationMechanism> mechanisms = io.vavr.collection.List.empty();

        private SecurityBuilder(UndertowBlueprint<C> parent, IdentityManager identityManager) {
            this.parent = parent;
            this.identityManager = identityManager;
        }

        public SecurityBuilder<C> constraintDriven() {
            return this.authenticationMode(AuthenticationMode.CONSTRAINT_DRIVEN);
        }

        public SecurityBuilder<C> proActive() {
            return this.authenticationMode(AuthenticationMode.PRO_ACTIVE);
        }

        public SecurityBuilder<C> authenticationMode(AuthenticationMode mode) {
            this.authenticationMode = mode;
            return this;
        }

        public SecurityBuilder<C> mechanism(AuthenticationMechanism ... mechanisms) {
            return this.mechanism(Arrays.asList(mechanisms));
        }

        public SecurityBuilder<C> mechanism(Iterable<? extends AuthenticationMechanism> mechanisms) {
            this.mechanisms = this.mechanisms.appendAll(mechanisms);
            return this;
        }

        public SecurityBuilder<C> basicAuth() {
            return this.mechanism(new AuthenticationMechanism[]{new BasicAuthenticationMechanism("undertow")});
        }

        public SecurityBuilder<C> basicAuth(String realm) {
            return this.mechanism(new AuthenticationMechanism[]{new BasicAuthenticationMechanism(realm)});
        }

        public UndertowBlueprint<C> end() {
            List mechanisms = (List)Option.of(this.mechanisms).filter(l -> !l.isEmpty()).map(Seq::asJava).getOrElseThrow(() -> new IllegalStateException("No security mechanisms"));
            return this.parent.handler(n -> new SecurityInitialHandler(this.authenticationMode, this.identityManager, (HttpHandler)new AuthenticationMechanismsHandler(n, mechanisms)));
        }
    }
}

