/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.codec;

import ch.raffael.meldioc.library.codec.ContentType;
import ch.raffael.meldioc.library.codec.ContentTypes;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Option;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

public final class HttpContentTypes {
    private HttpContentTypes() {
    }

    public static Option<ContentType> contentType(HttpServerExchange exchange) {
        return Option.of((Object)exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE)).flatMap(ContentTypes::parseContentType);
    }

    public static Tuple2<String, Charset> typeWithCharset(@Nullable String fullContentType, Charset fallback) {
        return HttpContentTypes.typeWithCharset(fullContentType).map2(cs -> (Charset)cs.getOrElse((Object)fallback));
    }

    public static Tuple2<String, Option<Charset>> typeWithCharset(@Nullable String fullContentType) {
        if (fullContentType == null) {
            return Tuple.of((Object)"", (Object)Option.none());
        }
        String contentType = fullContentType.trim();
        int pos = contentType.indexOf(59);
        if (pos < 0) {
            return Tuple.of((Object)contentType, HttpContentTypes.fixedCharset(contentType, (Option<Charset>)Option.none()));
        }
        String rest = contentType.substring(pos + 1);
        contentType = contentType.substring(0, pos).trim();
        Option charsetName = Option.of((Object)Headers.extractQuotedValueFromHeader((String)rest, (String)"charset"));
        return Tuple.of((Object)contentType, HttpContentTypes.fixedCharset(contentType, (Option<Charset>)charsetName.map(Charset::forName)));
    }

    private static Option<Charset> fixedCharset(String contentType, Option<Charset> declared) {
        switch (contentType) {
            case "application/json": {
                return Option.some((Object)StandardCharsets.UTF_8);
            }
        }
        return declared;
    }
}

