/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.codec;

import ch.raffael.meldioc.library.codec.ObjectDecoder;
import ch.raffael.meldioc.library.http.server.undertow.util.HttpStatusException;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.vavr.control.Option;

public interface HttpDecoder<C, B> {
    public void decode(HttpServerExchange var1, C var2, Consumer<? super C, ? super B> var3) throws Exception;

    public static <B> HttpDecoder<Object, B> wrapBuffered(ObjectDecoder<? extends B> decoder) {
        return (exchange, ctx, consumer) -> exchange.getRequestReceiver().receiveFullBytes((ex, bytes) -> {
            try {
                consumer.accept(exchange, decoder.decode(bytes));
            }
            catch (Exception e) {
                HttpStatusException.badRequest(e.toString(), e).endRequest(exchange);
            }
        }, HttpStatusException::endRequestWithServerError);
    }

    public static Option<String> contentType(HeaderMap headers) {
        String contentType = headers.getFirst(Headers.CONTENT_TYPE);
        if (contentType == null) {
            return Option.none();
        }
        int pos = contentType.indexOf(59);
        return Option.some((Object)(pos < 0 ? contentType : contentType.substring(0, pos)).trim());
    }

    @FunctionalInterface
    public static interface Consumer<C, B> {
        public void accept(HttpServerExchange var1, B var2) throws Exception;
    }
}

